/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.io.tags;

import com.atlassian.clover.Logger;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedIO;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.io.tags.Tags;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class TaggedOutputWriter
implements TaggedDataOutput {
    private final DataOutput out;
    private final Tags tags;

    public TaggedOutputWriter(DataOutput out, Tags tags) {
        this.out = out;
        this.tags = tags;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.writeTag(0);
        this.out.writeBoolean(v);
    }

    private void writeTagAndNullity(int tag, boolean isNull) throws IOException {
        this.writeTag(tag);
        this.out.writeBoolean(isNull);
    }

    private void writeTag(int tag) throws IOException {
        if (TaggedIO.isDebug()) {
            Logger.getInstance().debug("Tag: " + tag);
        }
        this.out.writeByte(tag);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.writeTag(1);
        this.out.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.writeTag(2);
        this.out.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeTag(3);
        this.out.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.writeTag(4);
        this.out.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.writeTag(5);
        this.out.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeTag(6);
        this.out.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeTag(7);
        this.out.writeDouble(v);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.writeTagAndNullity(8, s == null);
        if (s != null) {
            this.out.writeUTF(s);
        }
    }

    @Override
    public <T extends TaggedPersistent> void write(Class<? extends T> t, T p) throws IOException {
        if (TaggedIO.isDebug()) {
            Logger.getInstance().debug("Writing " + t.getName());
        }
        this.writeTagAndNullity(this.tags.getTagFor(t), p == null);
        if (p != null) {
            p.write(this);
        }
    }

    @Override
    public <T extends TaggedPersistent> void writeList(Class<T> type, List<T> elements) throws IOException {
        this.writeInt(elements.size());
        for (TaggedPersistent element : elements) {
            this.write(type, element);
        }
    }
}

