/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.tests;

import com.atlassian.clover.instr.tests.TestDetector;
import com.atlassian.clover.util.FilterUtils;
import java.io.File;
import org.jetbrains.annotations.Nullable;
import org.openclover.util.Objects;

public class AntPatternTestDetectorFilter
implements TestDetector {
    @Nullable
    final String[] includeFilter;
    @Nullable
    final String[] excludeFilter;
    private final File projectRoot;

    public AntPatternTestDetectorFilter(File projectRoot, @Nullable String[] includeFilter, @Nullable String[] excludeFilter) {
        this.includeFilter = includeFilter;
        this.excludeFilter = excludeFilter;
        this.projectRoot = projectRoot;
    }

    @Override
    public boolean isTypeMatch(TestDetector.SourceContext sourceContext, TestDetector.TypeContext typeContext) {
        return this.matchesPattern(sourceContext.getSourceFile());
    }

    @Override
    public boolean isMethodMatch(TestDetector.SourceContext sourceContext, TestDetector.MethodContext methodContext) {
        return this.matchesPattern(sourceContext.getSourceFile());
    }

    private boolean matchesPattern(File file) {
        String root;
        String path = file.getAbsolutePath();
        if (path.startsWith(root = this.rootWithEndingSeparator())) {
            String relative = path.substring(root.length());
            return FilterUtils.isIncluded(relative, this.excludeFilter, this.includeFilter, true);
        }
        return false;
    }

    private String rootWithEndingSeparator() {
        String root = this.projectRoot.getAbsolutePath();
        return root.endsWith(File.separator) ? root : String.valueOf(root) + File.separator;
    }

    public String toString() {
        return Objects.toStringBuilder(this).add("includeFilter", this.includeFilter).add("excludeFilter", this.excludeFilter).add("projectRoot", this.projectRoot).toString();
    }
}

