/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.instr.java.ClassEntryNode;
import com.atlassian.clover.instr.java.CloverToken;
import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.InstrumentationState;

public class ClassExitNode
extends Emitter {
    private ClassEntryNode entry;

    public ClassExitNode(ClassEntryNode entry, String className, int endline, int endcol) {
        super(endline, endcol);
        this.entry = entry;
    }

    @Override
    public void init(InstrumentationState state) {
        state.getSession().exitClass(this.getLine(), this.getColumn());
        state.setDetectTests(this.entry.isOuterDetectTests());
        CloverToken insertPoint = this.entry.getRecorderInsertPoint();
        if (insertPoint != null) {
            insertPoint.setEmittersEnabled(state.isDirty());
            this.entry.getRecorderInstrEmitter().setMaxDataIndex(state.getSession().getCurrentFileMaxIndex());
            state.setDirty(false);
        }
    }

    public ClassEntryNode getEntry() {
        return this.entry;
    }
}

