/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.context;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.BranchInfo;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.StatementInfo;
import com.atlassian.clover.cfg.instr.InstrumentationConfig;
import com.atlassian.clover.cfg.instr.MethodContextDef;
import com.atlassian.clover.cfg.instr.StatementContextDef;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.context.MethodRegexpContext;
import com.atlassian.clover.context.NamedContext;
import com.atlassian.clover.context.PropertyMethodRegexpContext;
import com.atlassian.clover.context.RegexpContext;
import com.atlassian.clover.context.SimpleContext;
import com.atlassian.clover.context.StatementRegexpContext;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.registry.Clover2Registry;
import com.atlassian.clover.registry.FileElementVisitor;
import com.atlassian.clover.registry.entities.FullBranchInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullStatementInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openclover.util.Lists;
import org.openclover.util.Maps;
import org.openclover.util.Sets;

public class ContextStore
implements TaggedPersistent {
    public static final int NO_INDEX = -1;
    public static final int CONTEXT_CLOVER_OFF = 0;
    public static final int CONTEXT_STATIC = 1;
    public static final int CONTEXT_INSTANCE = 2;
    public static final int CONTEXT_CTOR = 3;
    public static final int CONTEXT_METHOD = 4;
    public static final int CONTEXT_SWITCH = 5;
    public static final int CONTEXT_WHILE = 6;
    public static final int CONTEXT_DO = 7;
    public static final int CONTEXT_FOR = 8;
    public static final int CONTEXT_IF = 9;
    public static final int CONTEXT_ELSE = 10;
    public static final int CONTEXT_TRY = 11;
    public static final int CONTEXT_CATCH = 12;
    public static final int CONTEXT_FINALLY = 13;
    public static final int CONTEXT_SYNC = 14;
    public static final int CONTEXT_ASSERT = 15;
    public static final int CONTEXT_DEPRECATED = 16;
    public static final int CONTEXT_PRIVATE_METHOD = 17;
    public static final int CONTEXT_PROPERTY_ACCESSOR = 18;
    public static final int NEXT_INDEX = 19;
    private static Map<String, SimpleContext> reservedContexts = new LinkedHashMap<String, SimpleContext>();
    private static Map<String, MethodRegexpContext> reservedMethodContexts = new LinkedHashMap<String, MethodRegexpContext>();
    private static Set<String> reservedNames = Sets.newHashSet();
    private int nextIndex = 19;
    private Map<String, MethodRegexpContext> methodContexts = new LinkedHashMap<String, MethodRegexpContext>();
    private Map<String, StatementRegexpContext> statementContexts = new LinkedHashMap<String, StatementRegexpContext>();
    private transient ConcurrentHashMap<com.atlassian.clover.api.registry.ContextSet, String> namedContextCache;

    static {
        ContextStore.addContext(reservedContexts, new SimpleContext(0, "SourceDirective"));
        ContextStore.addContext(reservedContexts, new SimpleContext(1, "static"));
        ContextStore.addContext(reservedContexts, new SimpleContext(3, "constructor"));
        ContextStore.addContext(reservedContexts, new SimpleContext(4, "method"));
        ContextStore.addContext(reservedContexts, new SimpleContext(5, "switch"));
        ContextStore.addContext(reservedContexts, new SimpleContext(6, "while"));
        ContextStore.addContext(reservedContexts, new SimpleContext(7, "do"));
        ContextStore.addContext(reservedContexts, new SimpleContext(8, "for"));
        ContextStore.addContext(reservedContexts, new SimpleContext(9, "if"));
        ContextStore.addContext(reservedContexts, new SimpleContext(10, "else"));
        ContextStore.addContext(reservedContexts, new SimpleContext(11, "try"));
        ContextStore.addContext(reservedContexts, new SimpleContext(12, "catch"));
        ContextStore.addContext(reservedContexts, new SimpleContext(13, "finally"));
        ContextStore.addContext(reservedContexts, new SimpleContext(14, "sync"));
        ContextStore.addContext(reservedContexts, new SimpleContext(15, "assert"));
        ContextStore.addContext(reservedContexts, new SimpleContext(16, "@deprecated"));
        ContextStore.addContext(reservedMethodContexts, new MethodRegexpContext(17, "private", Pattern.compile("(.* )?private .*")));
        ContextStore.addContext(reservedMethodContexts, new PropertyMethodRegexpContext(18, "property"));
        reservedNames.addAll(reservedContexts.keySet());
        reservedNames.addAll(reservedMethodContexts.keySet());
    }

    public ContextStore() {
        this.methodContexts.putAll(reservedMethodContexts);
        this.initCache();
    }

    private ContextStore(int nextIndex, Map<String, MethodRegexpContext> methodContexts, Map<String, StatementRegexpContext> statementContexts) {
        this.nextIndex = nextIndex;
        this.methodContexts = methodContexts;
        this.statementContexts = statementContexts;
        this.initCache();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.initCache();
    }

    private void initCache() {
        this.namedContextCache = new ConcurrentHashMap();
    }

    public int addMethodContext(MethodRegexpContext ctx) throws CloverException {
        MethodRegexpContext context = new MethodRegexpContext(ctx);
        this.checkForReservedName(context);
        int index = -1;
        index = this.removeExistingContext(context, this.statementContexts, index);
        index = this.removeExistingContext(context, this.methodContexts, index);
        if (index == -1) {
            index = this.nextIndex++;
        }
        context.setIndex(index);
        ContextStore.logContext("adding", "method", context, index);
        ContextStore.addContext(this.methodContexts, context);
        return index;
    }

    private int removeExistingContext(NamedContext context, Map contexts, int index) {
        NamedContext existingContext = (NamedContext)contexts.get(context.getName());
        if (existingContext != null) {
            index = existingContext.getIndex();
            contexts.remove(context.getName());
            this.namedContextCache.clear();
        }
        return index;
    }

    public int addStatementContext(StatementRegexpContext ctx) throws CloverException {
        StatementRegexpContext context = new StatementRegexpContext(ctx);
        this.checkForReservedName(context);
        int index = -1;
        index = this.removeExistingContext(context, this.methodContexts, index);
        index = this.removeExistingContext(context, this.statementContexts, index);
        if (index == -1) {
            index = this.nextIndex++;
        }
        context.setIndex(index);
        ContextStore.logContext("adding", "statement", context, index);
        ContextStore.addContext(this.statementContexts, context);
        return index;
    }

    private static void logContext(String verb, String type, RegexpContext context, int index) {
        if (Logger.isDebug()) {
            Logger.getInstance().debug(String.valueOf(verb) + " " + type + " context id=" + index + ", name=" + context.getName() + ", pattern=" + context.getPattern());
        }
    }

    public List<MethodRegexpContext> getMethodContexts() {
        return Lists.newArrayList(this.methodContexts.values());
    }

    public List<StatementRegexpContext> getStatementContexts() {
        return Lists.newArrayList(this.statementContexts.values());
    }

    public List<NamedContext> getReservedContexts() {
        return Lists.newArrayList(reservedContexts.values());
    }

    public List<MethodRegexpContext> getReservedMethodContexts() {
        return Lists.newArrayList(reservedMethodContexts.values());
    }

    public List<NamedContext> getAllUserContexts() {
        ArrayList<NamedContext> contexts = Lists.newArrayList(this.methodContexts.values());
        contexts.addAll(this.statementContexts.values());
        contexts.removeAll(reservedMethodContexts.values());
        return contexts;
    }

    public ContextSet createContextSetFilter(String spec) {
        return this.createContextSetFilter(spec, false);
    }

    public ContextSet createContextSetFilter(String spec, boolean invert) {
        ContextSet result = new ContextSet(this.nextIndex);
        StringTokenizer toks = new StringTokenizer(spec, ", ");
        while (toks.hasMoreTokens()) {
            String filter = toks.nextToken();
            NamedContext context = this.getContext(filter);
            if (context != null) {
                result = result.set(context.getIndex());
                continue;
            }
            Logger.getInstance().warn("Ignoring unknown context filter \"" + filter + "\"");
        }
        if (invert) {
            result = result.flip(0, this.nextIndex);
        }
        return result.set(0);
    }

    public NamedContext getContext(String name) {
        NamedContext result = reservedContexts.get(name);
        if (result == null) {
            result = reservedMethodContexts.get(name);
        }
        if (result == null) {
            result = this.methodContexts.get(name);
        }
        if (result == null) {
            result = this.statementContexts.get(name);
        }
        return result;
    }

    public String getContextsAsString(com.atlassian.clover.api.registry.ContextSet set) {
        String ctxAsString = this.namedContextCache.get(set);
        if (ctxAsString != null) {
            return ctxAsString;
        }
        NamedContext[] contexts = this.getContexts(set);
        StringBuilder contextString = new StringBuilder();
        String sep = "";
        NamedContext[] namedContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            NamedContext context = namedContextArray[n2];
            contextString.append(sep);
            contextString.append(context.getName());
            sep = ", ";
            ++n2;
        }
        this.namedContextCache.putIfAbsent(set, contextString.toString());
        return contextString.toString();
    }

    public NamedContext[] getContexts(com.atlassian.clover.api.registry.ContextSet ctxSet) {
        ArrayList<NamedContext> allContexts = Lists.newArrayList(reservedContexts.values());
        allContexts.addAll(reservedMethodContexts.values());
        allContexts.addAll(this.methodContexts.values());
        allContexts.addAll(this.statementContexts.values());
        ArrayList<NamedContext> contexts = Lists.newArrayList();
        int i = ctxSet.nextSetBit(0);
        while (i >= 0) {
            this.collectContextAt(allContexts, i, contexts);
            i = ctxSet.nextSetBit(i + 1);
        }
        return contexts.toArray(new NamedContext[0]);
    }

    public static void saveCustomContexts(InstrumentationConfig config) throws CloverException {
        if (config.hasCustomContexts()) {
            Clover2Registry clover2Registry;
            RegexpContext context;
            ContextStore contexts = new ContextStore();
            if (config.getMethodContexts() != null) {
                for (MethodContextDef methodContextDef : config.getMethodContexts()) {
                    methodContextDef.validate();
                    try {
                        context = new MethodRegexpContext(methodContextDef.getName(), Pattern.compile(methodContextDef.getRegexp()), methodContextDef.getMaxComplexity(), methodContextDef.getMaxStatements(), methodContextDef.getMaxAggregatedComplexity(), methodContextDef.getMaxAggregatedStatements());
                        contexts.addMethodContext((MethodRegexpContext)context);
                    }
                    catch (PatternSyntaxException e) {
                        throw new CloverException("Invalid context definition: " + e.getMessage(), e);
                    }
                }
            }
            if (config.getStatementContexts() != null) {
                for (StatementContextDef statementContextDef : config.getStatementContexts()) {
                    statementContextDef.validate();
                    try {
                        context = new StatementRegexpContext(statementContextDef.getName(), Pattern.compile(statementContextDef.getRegexp()));
                        contexts.addStatementContext((StatementRegexpContext)context);
                    }
                    catch (PatternSyntaxException e) {
                        throw new CloverException("Invalid context definition: " + e.getMessage(), e);
                    }
                }
            }
            try {
                clover2Registry = Clover2Registry.createOrLoad(config.getRegistryFile(), config.getProjectName());
            }
            catch (IOException e) {
                throw new CloverException(String.valueOf(e.getClass().getName()) + " accessing Clover database: " + e.getMessage(), e);
            }
            clover2Registry.setContextStore(contexts);
            try {
                clover2Registry.saveAndOverwriteFile();
            }
            catch (IOException e) {
                throw new CloverException(String.valueOf(e.getClass().getName()) + " writing Clover database: " + e.getMessage());
            }
        }
    }

    public static ContextMapper mergeContextStores(Clover2Registry newReg, Collection<CloverDatabase> mergingDbs) {
        ContextStore merged = new ContextStore();
        HashMap oldMappings = Maps.newHashMap();
        HashMap<CloverDatabase, Map<Integer, Integer>> newMappings = Maps.newHashMap();
        ContextStore smallest = null;
        for (CloverDatabase mergingDb : mergingDbs) {
            ContextStore store = mergingDb.getContextStore();
            if (smallest != null && store.size() >= smallest.size()) continue;
            smallest = store;
        }
        for (NamedContext namedContext : smallest.getAllUserContexts()) {
            RegexpContext context = (RegexpContext)namedContext;
            Integer contextIdx = context.getIndex();
            boolean universal = true;
            for (CloverDatabase db : mergingDbs) {
                ContextStore store = db.getContextStore();
                int equiv = store.getEquivalentContextIndex(context);
                if (equiv >= 0) {
                    HashMap oldMapping = (HashMap)oldMappings.get(db);
                    if (oldMapping == null) {
                        oldMapping = Maps.newHashMap();
                        oldMappings.put(db, oldMapping);
                    }
                    oldMapping.put(contextIdx, equiv);
                    continue;
                }
                universal = false;
                break;
            }
            if (!universal) continue;
            ContextStore.logContext("merging", context.getClass().getName(), context, context.getIndex());
            int mergedIndex = merged.addContextFromTemplate(context);
            if (mergedIndex == -1) {
                Logger.getInstance().error("skipping problem user context " + context + ", " + context.getClass().getName());
                continue;
            }
            for (CloverDatabase db : mergingDbs) {
                Map oldMapping = (Map)oldMappings.get(db);
                Integer equiv = (Integer)oldMapping.get(contextIdx);
                HashMap newMapping = (HashMap)newMappings.get(db);
                if (newMapping == null) {
                    newMapping = Maps.newHashMap();
                    newMappings.put(db, newMapping);
                }
                newMapping.put(equiv, mergedIndex);
            }
        }
        List<NamedContext> allReservedContexts = merged.getReservedContexts();
        allReservedContexts.addAll(merged.getReservedMethodContexts());
        for (Map mapping : newMappings.values()) {
            for (NamedContext context : allReservedContexts) {
                Integer contextIdx = context.getIndex();
                mapping.put(contextIdx, contextIdx);
            }
        }
        newReg.setContextStore(merged);
        return new ContextMapper(merged, newMappings);
    }

    private int addContextFromTemplate(RegexpContext context) {
        int newIndex = -1;
        try {
            if (context instanceof MethodRegexpContext) {
                newIndex = this.addMethodContext((MethodRegexpContext)context);
            } else if (context instanceof StatementRegexpContext) {
                newIndex = this.addStatementContext((StatementRegexpContext)context);
            } else {
                Logger.getInstance().warn("Expecting a user defined context in merge, but got " + context.getClass().getName() + ", " + context);
            }
        }
        catch (CloverException e) {
            Logger.getInstance().error("when merging, encountered context with illegal name, skipping", e);
        }
        return newIndex;
    }

    private int getEquivalentContextIndex(RegexpContext context) {
        Collection<RegexpContext> search = null;
        if (context instanceof MethodRegexpContext) {
            search = this.methodContexts.values();
        } else if (context instanceof StatementRegexpContext) {
            search = this.statementContexts.values();
        }
        if (search != null) {
            for (RegexpContext regexpContext : search) {
                if (!regexpContext.isEquivalent(context)) continue;
                return regexpContext.getIndex();
            }
        }
        return -1;
    }

    public int size() {
        return reservedContexts.size() + this.methodContexts.size() + this.statementContexts.size();
    }

    private void collectContextAt(List<NamedContext> reservedList, int i, List<NamedContext> contexts) {
        for (NamedContext namedContext : reservedList) {
            if (namedContext.getIndex() != i) continue;
            contexts.add(namedContext);
            break;
        }
    }

    private static <T extends NamedContext> void addContext(Map<String, T> map, T context) {
        map.put(context.getName(), context);
    }

    public static boolean isReservedName(String name) {
        return reservedNames.contains(name);
    }

    private void checkForReservedName(NamedContext context) throws CloverException {
        if (ContextStore.isReservedName(context.getName())) {
            throw new CloverException("The name \"" + context.getName() + "\" is already in use by one of the builtin contexts");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextStore that = (ContextStore)o;
        if (this.nextIndex != that.nextIndex) {
            return false;
        }
        if (!Objects.equals(this.methodContexts, that.methodContexts)) {
            return false;
        }
        return Objects.equals(this.statementContexts, that.statementContexts);
    }

    public int hashCode() {
        int result = this.nextIndex;
        result = 31 * result + (this.methodContexts != null ? this.methodContexts.hashCode() : 0);
        result = 31 * result + (this.statementContexts != null ? this.statementContexts.hashCode() : 0);
        return result;
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        out.writeInt(this.nextIndex);
        HashSet<String> customNames = Sets.newHashSet(this.methodContexts.keySet());
        customNames.removeAll(reservedNames);
        out.writeInt(customNames.size());
        for (Map.Entry<String, MethodRegexpContext> entry : this.methodContexts.entrySet()) {
            if (reservedNames.contains(entry.getKey())) continue;
            out.write(MethodRegexpContext.class, entry.getValue());
        }
        out.writeInt(this.statementContexts.size());
        for (Map.Entry<String, RegexpContext> entry : this.statementContexts.entrySet()) {
            out.write(StatementRegexpContext.class, (StatementRegexpContext)entry.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ContextStore read(TaggedDataInput in) throws IOException {
        void var4_5;
        int nextIndex = in.readInt();
        int numMethodContexts = in.readInt();
        HashMap<String, MethodRegexpContext> methodContexts = Maps.newHashMap();
        boolean bl = false;
        while (var4_5 < numMethodContexts) {
            MethodRegexpContext ctx = in.read(MethodRegexpContext.class);
            methodContexts.put(ctx.getName(), ctx);
            ++var4_5;
        }
        for (Map.Entry entry : reservedMethodContexts.entrySet()) {
            methodContexts.put((String)entry.getKey(), (MethodRegexpContext)entry.getValue());
        }
        int n = in.readInt();
        HashMap<String, StatementRegexpContext> stmtContexts = Maps.newHashMap();
        int i2 = 0;
        while (i2 < n) {
            StatementRegexpContext ctx = in.read(StatementRegexpContext.class);
            stmtContexts.put(ctx.getName(), ctx);
            ++i2;
        }
        return new ContextStore(nextIndex, methodContexts, stmtContexts);
    }

    public static class ContextMapper {
        private ContextStore contextStore;
        private Map<CloverDatabase, Map<Integer, Integer>> mappings;

        ContextMapper(ContextStore cs, Map<CloverDatabase, Map<Integer, Integer>> mappings) {
            this.contextStore = cs;
            this.mappings = mappings;
        }

        public void applyContextMapping(CloverDatabase db, FullFileInfo finfo) {
            final Map<Integer, Integer> mapping = this.mappings.get(db);
            if (mapping == null) {
                return;
            }
            finfo.visitElements(new FileElementVisitor(){

                @Override
                public void visitClass(ClassInfo info) {
                }

                @Override
                public void visitMethod(MethodInfo info) {
                    ((FullMethodInfo)info).setContext(ContextSet.remap((ContextSet)info.getContext(), mapping));
                }

                @Override
                public void visitStatement(StatementInfo info) {
                    ((FullStatementInfo)info).setContext(ContextSet.remap((ContextSet)info.getContext(), mapping));
                }

                @Override
                public void visitBranch(BranchInfo info) {
                    ((FullBranchInfo)info).setContext(ContextSet.remap((ContextSet)info.getContext(), mapping));
                }
            });
        }

        public ContextStore getContextStore() {
            return this.contextStore;
        }
    }
}

