/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.cfg.instr.java;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.instr.InstrumentationConfig;
import com.atlassian.clover.cfg.instr.java.LambdaInstrumentation;
import com.atlassian.clover.cfg.instr.java.SourceLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class JavaInstrumentationConfig
extends InstrumentationConfig {
    public static final String JAVA_LANG_PREFIX = "java.lang.";
    private SourceLevel sourceLevel = SourceLevel.autoDetect();
    private boolean fullyQualifiedJavaNames = true;
    private String instrFileExtension = "java";
    private LambdaInstrumentation instrumentLambda = LambdaInstrumentation.NONE;
    private File sourceDir;
    private File destDir;
    private List<String> sourceFiles = new ArrayList<String>();

    public String getJavaLangPrefix() {
        return this.fullyQualifiedJavaNames ? JAVA_LANG_PREFIX : "";
    }

    public void setFullyQualifyJavaLang(boolean fullyQualifiedJavaNames) {
        this.fullyQualifiedJavaNames = fullyQualifiedJavaNames;
    }

    public SourceLevel getSourceLevel() {
        return this.sourceLevel;
    }

    public void setSourceLevel(SourceLevel sourceLevel) {
        this.sourceLevel = sourceLevel;
    }

    public void setInstrFileExtension(String extension) {
        this.instrFileExtension = extension;
    }

    public String getInstrFileExtension() {
        return this.instrFileExtension;
    }

    public void setInstrumentLambda(LambdaInstrumentation instrumentLambda) {
        this.instrumentLambda = instrumentLambda;
    }

    public LambdaInstrumentation getInstrumentLambda() {
        return this.instrumentLambda;
    }

    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void addSourceFile(String fileName) {
        this.sourceFiles.add(fileName);
    }

    public List<String> getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    public boolean validate() {
        if (this.getInitString() == null) {
            try {
                this.createDefaultInitStringDir();
            }
            catch (CloverException e) {
                this.setValidationFailureReason("No initstring value supplied, and default location could not be created: " + e.getMessage());
                return false;
            }
        }
        if (this.sourceDir == null && this.sourceFiles.size() == 0) {
            this.setValidationFailureReason("Neither source directory nor source files are specified");
            return false;
        }
        if (this.destDir == null) {
            this.setValidationFailureReason("No destination directory specified");
            return false;
        }
        if (this.sourceDir != null) {
            if (this.sourceDir.equals(this.destDir)) {
                this.setValidationFailureReason("Source and destination directories cannot be the same.");
                return false;
            }
            File destDirParent = this.destDir.getParentFile();
            while (destDirParent != null) {
                if (destDirParent.equals(this.sourceDir)) {
                    this.setValidationFailureReason("Cannot specify a destination directory that is a nested dir of the source directory.");
                    return false;
                }
                destDirParent = destDirParent.getParentFile();
            }
        }
        if (this.getFlushPolicy() == 0 && this.getFlushInterval() != 0) {
            this.setValidationFailureReason("Flush policy is 'directed', so you cannot specify a flush interval. To specify an interval change the flush policy to interval or threaded.");
            return false;
        }
        if ((this.getFlushPolicy() == 1 || this.getFlushPolicy() == 2) && this.getFlushInterval() == 0) {
            this.setValidationFailureReason("When using either 'interval' or 'threaded' flush policy, a flush interval must be specified.");
            return false;
        }
        return true;
    }
}

