/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CloverDatabaseSpec;
import com.atlassian.clover.ProgressListener;
import com.atlassian.clover.ant.tasks.AbstractCloverTask;
import com.atlassian.clover.cfg.Interval;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.openclover.util.Lists;

public class CloverMergeTask
extends AbstractCloverTask {
    private List<CloverDatabaseSpec> cloverDbs = Lists.newArrayList();
    private List<CloverDbSet> cloverDbSets;
    private boolean update = false;
    private Interval updateSpan = Interval.DEFAULT_SPAN;

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public void setUpdateSpan(Interval updateSpan) {
        this.updateSpan = updateSpan;
    }

    public void addCloverDb(CloverDatabaseSpec db) {
        this.cloverDbs.add(db);
    }

    public void addCloverDbSet(CloverDbSet dbset) {
        if (this.cloverDbSets == null) {
            this.cloverDbSets = Lists.newArrayList();
        }
        this.cloverDbSets.add(dbset);
    }

    @Override
    public void cloverExecute() {
        if (this.getInitString() == null) {
            throw new BuildException("You must specify the location of the new clover database with the \"initString\" attribute");
        }
        String initString = this.resolveInitString();
        if (this.cloverDbSets != null) {
            for (CloverDbSet dbset : this.cloverDbSets) {
                this.cloverDbs.addAll(dbset.getIncludedDbs());
            }
        }
        if (this.cloverDbs.size() == 0 && !this.update) {
            throw new BuildException("You must specify one or more coverage databases to merge using a nested  <cloverdb> or <cloverdbset> element.");
        }
        try {
            CloverDatabase.merge(this.cloverDbs, initString, this.update, this.updateSpan, new ProgressListener(){

                @Override
                public void handleProgress(String desc, float pc) {
                    CloverMergeTask.this.log(desc);
                }
            });
        }
        catch (Exception e) {
            throw new BuildException("Error writing new clover db at \"" + initString + "\": " + e.getMessage(), (Throwable)e);
        }
    }

    public static class CloverDbSet
    extends FileSet {
        private Interval span = Interval.DEFAULT_SPAN;

        public Interval getSpan() {
            return this.span;
        }

        public void setSpan(Interval span) {
            this.span = span;
        }

        public List<CloverDatabaseSpec> getIncludedDbs() {
            CloverDbSet fs = this.isReference() ? (FileSet)this.getCheckedRef(FileSet.class, "fileset") : this;
            String[] files = fs.getDirectoryScanner(this.getProject()).getIncludedFiles();
            LinkedList<CloverDatabaseSpec> dbs = Lists.newLinkedList();
            String baseDir = fs.getDir(this.getProject()).getAbsolutePath();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                dbs.add(new CloverDatabaseSpec(String.valueOf(baseDir) + "/" + fileName, this.span));
                ++n2;
            }
            return dbs;
        }
    }
}

