/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import com.atlassian.clover.PrematureLibraryLoader;
import com_atlassian_clover.CloverVersionInfo;
import java.io.PrintStream;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.openclover.util.ClassPathUtil;

public class CloverEnvTask
extends Task {
    public void init() throws BuildException {
        PrematureLibraryLoader.doOnce();
        super.init();
    }

    public void execute() throws BuildException {
        this.logEnvironment();
        ProjectHelper helper = (ProjectHelper)this.getProject().getReference("ant.projectHelper");
        try {
            URL importURL = CloverEnvTask.class.getResource("clover.xml");
            this.log("Loading clover.xml: " + importURL);
            helper.parse(this.getProject(), (Object)importURL);
        }
        catch (BuildException ex) {
            throw ProjectHelper.addLocationToBuildException((BuildException)ex, (Location)this.getLocation());
        }
        catch (Throwable e) {
            this.log("An unexpected error occurred while trying to import the bundled clover build file.");
            throw new BuildException(e.getMessage(), e);
        }
    }

    private void logEnvironment() {
        if (CloverEnvTask.isDebug()) {
            Diagnostics.doReport((PrintStream)System.out);
            this.log("Clover loaded from: " + ClassPathUtil.getCloverJarPath());
            this.log(CloverVersionInfo.formatVersionInfo());
        }
    }

    private static boolean isDebug() {
        return System.getProperty("clover.debug") != null;
    }
}

