/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

import clover.org.slf4j.LoggerFactory;
import com.atlassian.clover.Logger;

public class SLF4JLogger
extends Logger {
    private final clover.org.slf4j.Logger instance;

    public SLF4JLogger(String category) {
        this.instance = LoggerFactory.getLogger(category);
    }

    @Override
    public void log(int level, String msg, Throwable t) {
        if (level == 4 || level == 3) {
            this.instance.debug(msg, t);
        } else if (level == 2) {
            this.instance.info(msg, t);
        } else if (level == 1) {
            this.instance.warn(msg, t);
        } else if (level == 0) {
            this.instance.error(msg, t);
        }
    }

    public static boolean init() {
        try {
            Class.forName("clover.org.slf4j.Logger");
            Class.forName("clover.org.slf4j.LoggerFactory");
            return true;
        }
        catch (ClassNotFoundException | LinkageError e) {
            Logger.getInstance().debug("Error initialising SLF4J", e);
            return false;
        }
    }

    public static class Factory
    implements Logger.Factory {
        @Override
        public Logger getLoggerInstance(String category) {
            return new SLF4JLogger(category);
        }
    }
}

