/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CloverDatabaseSpec;
import com.atlassian.clover.Logger;
import com.atlassian.clover.ProgressListener;
import com.atlassian.clover.cfg.Interval;
import java.util.LinkedList;
import java.util.Map;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class CloverMerge {
    private static String initString;
    private static Map<String, Interval> mergingDbs;
    private static boolean update;
    private static Interval updateSpan;

    static {
        update = false;
        updateSpan = Interval.DEFAULT_SPAN;
    }

    public static void main(String[] args) {
        System.exit(CloverMerge.mainImpl(args));
    }

    public static int mainImpl(String[] args) {
        if (!CloverMerge.processArgs(args)) {
            return 1;
        }
        LinkedList<CloverDatabaseSpec> databases = Lists.newLinkedList();
        for (String db : mergingDbs.keySet()) {
            databases.add(new CloverDatabaseSpec(db, mergingDbs.get(db)));
        }
        try {
            CloverDatabase.merge(databases, initString, update, updateSpan, new ProgressListener(){

                @Override
                public void handleProgress(String desc, float pc) {
                    System.out.println(desc);
                }
            });
        }
        catch (Exception e) {
            Logger.getInstance().error("Error writing new clover db '" + initString, e);
            return 1;
        }
        return 0;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        System.err.println("  USAGE: " + CloverMerge.class.getName() + " [OPTIONS] PARAMS [DBFILES...]");
        System.err.println();
        System.err.println("  PARAMS:");
        System.err.println("    -i, --initstring <file>\t Clover initstring. This is the path where the new merged");
        System.err.println("\t\t\t\t database will be written.");
        System.err.println();
        System.err.println();
        System.err.println("  OPTIONS:");
        System.err.println("    -u, --update [interval]\t if specified, any existing database specified by -i will be included in the");
        System.err.println("\t\t\t\t merge. If interval is specified, it is used as the span when reading the existing database.");
        System.err.println("    -s, --span <interval>\t Specifies the span to use when reading subsequent databases to be ");
        System.err.println("\t\t\t\t merged. This option can be specified more than once and applies to all databases ");
        System.err.println("\t\t\t\t specified after the option, or until another span in specified.");
        System.err.println("    -v, --verbose\t\t Enable verbose logging.");
        System.err.println("    -d, --debug\t\t Enable debug logging.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean processArgs(String[] args) {
        try {
            mergingDbs = Maps.newHashMap();
            int i = 0;
            Interval interval = Interval.ZERO_SECONDS;
            while (true) {
                if (i >= args.length) {
                    if (initString != null) break;
                    CloverMerge.usage("Need to specify an initstring for the merged database.");
                    return false;
                }
                switch (args[i]) {
                    case "--initstring": 
                    case "-i": {
                        initString = args[++i];
                        break;
                    }
                    case "-u": 
                    case "--update": {
                        update = true;
                        if (i >= args.length - 1) break;
                        try {
                            updateSpan = new Interval(args[++i]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            --i;
                        }
                        break;
                    }
                    case "-s": 
                    case "--span": {
                        ++i;
                        try {
                            interval = new Interval(args[i]);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            CloverMerge.usage("Bad interval format '" + args[i] + "'");
                            return false;
                        }
                    }
                    case "-v": 
                    case "--verbose": {
                        Logger.setVerbose(true);
                        break;
                    }
                    case "--debug": 
                    case "-d": {
                        Logger.setDebug(true);
                        break;
                    }
                    default: {
                        mergingDbs.put(args[i], interval);
                    }
                }
                ++i;
            }
            if (mergingDbs.size() == 0 && !update) {
                CloverMerge.usage("No databases to merge.");
                return false;
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            CloverMerge.usage("Missing a parameter.");
            return false;
        }
    }
}

