/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

public final class CloverLicense {
    public static final long ONE_DAY = 86400000L;
    private final String productName;
    private final String licenseName;
    private final String ownerName;
    private final long licenseExpiryDate;
    private final long maintenanceExpiryDate;

    CloverLicense(String productName, String licenseName, String ownerName, long licenseExpiryDate, long maintenanceExpiryDate) {
        this.productName = productName;
        this.licenseName = licenseName;
        this.ownerName = ownerName;
        this.licenseExpiryDate = licenseExpiryDate;
        this.maintenanceExpiryDate = maintenanceExpiryDate;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public String getOrganisation() {
        return this.ownerName;
    }

    public long getLicenseExpiryDate() {
        return this.licenseExpiryDate;
    }

    public long getMaintenanceExpiryDate() {
        return this.maintenanceExpiryDate;
    }

    public boolean expires() {
        return this.licenseExpiryDate != 0L;
    }

    public boolean maintenanceExpires() {
        return this.maintenanceExpiryDate != 0L;
    }

    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    public boolean isMaintenanceExpired() {
        return this.isMaintenanceExpired(System.currentTimeMillis());
    }

    public String getOwnerStatement() {
        return String.valueOf(this.productName) + " is " + this.licenseName + " software.";
    }

    public String getPreExpiryStatement() {
        return "";
    }

    public String getPostExpiryStatement() {
        return "";
    }

    public String getContactInfoStatement() {
        return "";
    }

    public long getDaysTillExpiry() {
        return this.getDaysTillExpiry(System.currentTimeMillis());
    }

    private boolean isExpired(long time) {
        return this.expires() && time > this.licenseExpiryDate;
    }

    private boolean isMaintenanceExpired(long time) {
        return this.maintenanceExpires() && time > this.maintenanceExpiryDate;
    }

    private long getDaysTillExpiry(long now) {
        long days = this.countDays(this.licenseExpiryDate - now);
        return days < 0L ? 0L : days;
    }

    private long countDays(long aMilliseconds) {
        return aMilliseconds / 86400000L;
    }
}

