/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.data.general;

import clover.org.jfree.chart.renderer.PaintScale;
import clover.org.jfree.chart.util.ParamChecks;
import clover.org.jfree.data.general.HeatMapDataset;
import clover.org.jfree.data.xy.XYDataset;
import clover.org.jfree.data.xy.XYSeries;
import clover.org.jfree.data.xy.XYSeriesCollection;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.image.BufferedImage;

public abstract class HeatMapUtilities {
    public static XYDataset extractRowFromHeatMapDataset(HeatMapDataset dataset, int row, Comparable seriesName) {
        XYSeries series = new XYSeries(seriesName);
        int cols = dataset.getXSampleCount();
        for (int c = 0; c < cols; ++c) {
            series.add(dataset.getXValue(c), dataset.getZValue(c, row));
        }
        XYSeriesCollection result = new XYSeriesCollection(series);
        return result;
    }

    public static XYDataset extractColumnFromHeatMapDataset(HeatMapDataset dataset, int column, Comparable seriesName) {
        XYSeries series = new XYSeries(seriesName);
        int rows = dataset.getYSampleCount();
        for (int r = 0; r < rows; ++r) {
            series.add(dataset.getYValue(r), dataset.getZValue(column, r));
        }
        XYSeriesCollection result = new XYSeriesCollection(series);
        return result;
    }

    public static BufferedImage createHeatMapImage(HeatMapDataset dataset, PaintScale paintScale) {
        ParamChecks.nullNotPermitted(dataset, "dataset");
        ParamChecks.nullNotPermitted(paintScale, "paintScale");
        int xCount = dataset.getXSampleCount();
        int yCount = dataset.getYSampleCount();
        BufferedImage image = new BufferedImage(xCount, yCount, 2);
        Graphics2D g2 = image.createGraphics();
        for (int xIndex = 0; xIndex < xCount; ++xIndex) {
            for (int yIndex = 0; yIndex < yCount; ++yIndex) {
                double z = dataset.getZValue(xIndex, yIndex);
                Paint p = paintScale.getPaint(z);
                g2.setPaint(p);
                g2.fillRect(xIndex, yCount - yIndex - 1, 1, 1);
            }
        }
        return image;
    }
}

