/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.fhir.util;

import ca.uhn.fhir.context.FhirVersionEnum;

public class VersionUtilities {
    public static FhirVersionEnum enumForVersion(String fhirVersion) {
        if (fhirVersion == null || fhirVersion.isEmpty()) {
            throw new IllegalArgumentException("fhirVersion can not be null or empty");
        }
        try {
            return FhirVersionEnum.valueOf((String)fhirVersion.toUpperCase());
        }
        catch (Exception exception) {
            FhirVersionEnum version = FhirVersionEnum.forVersionString((String)fhirVersion);
            if (version != null) {
                return version;
            }
            switch (fhirVersion.substring(0, 1)) {
                case "2": {
                    return FhirVersionEnum.DSTU2;
                }
                case "3": {
                    return FhirVersionEnum.DSTU3;
                }
                case "4": {
                    return FhirVersionEnum.R4;
                }
                case "5": {
                    return FhirVersionEnum.R5;
                }
            }
            throw new IllegalArgumentException("unknown or unsupported FHIR version");
        }
    }
}

