/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.fhir.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.fhirpath.IFhirPath;
import java.util.HashMap;
import java.util.Map;

public class FhirPathCache {
    private static final Map<FhirVersionEnum, IFhirPath> fhirPathCache = new HashMap<FhirVersionEnum, IFhirPath>();

    public static IFhirPath cachedForContext(FhirContext fhirContext) {
        return fhirPathCache.computeIfAbsent(fhirContext.getVersion().getVersion(), x -> fhirContext.newFhirPath());
    }

    public static IFhirPath cachedForVersion(FhirVersionEnum fhirVersionEnum) {
        return fhirPathCache.computeIfAbsent(fhirVersionEnum, x -> x.newContext().newFhirPath());
    }
}

