/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.engine.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildResourceBlockDefinition;
import ca.uhn.fhir.context.RuntimeResourceBlockDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.runtime.Code;

public class ValueSetUtil {
    public static IBase getCompose(FhirContext fhirContext, IBaseResource valueSet) {
        BaseRuntimeChildDefinition composeChild = ValueSetUtil.getComposeDefinition(fhirContext);
        List compose = composeChild.getAccessor().getValues((IBase)valueSet);
        if (compose.isEmpty()) {
            return null;
        }
        if (compose.size() > 1) {
            throw new IllegalArgumentException("ValueSet has multiple compose definitions.");
        }
        return (IBase)compose.get(0);
    }

    public static List<IBase> getIncludes(FhirContext fhirContext, IBaseResource valueSet) {
        IBase compose = ValueSetUtil.getCompose(fhirContext, valueSet);
        if (compose == null) {
            return null;
        }
        BaseRuntimeChildDefinition includeChild = ValueSetUtil.getIncludeDefinition(fhirContext);
        List includeComponents = includeChild.getAccessor().getValues(compose);
        if (includeComponents.isEmpty()) {
            return null;
        }
        return includeComponents;
    }

    public static List<IBase> getExcludes(FhirContext fhirContext, IBaseResource valueSet) {
        IBase compose = ValueSetUtil.getCompose(fhirContext, valueSet);
        if (compose == null) {
            return null;
        }
        BaseRuntimeChildDefinition excludeChild = ValueSetUtil.getExcludeDefinition(fhirContext);
        List excludeComponents = excludeChild.getAccessor().getValues(compose);
        if (excludeComponents == null || excludeComponents.isEmpty()) {
            return null;
        }
        return excludeComponents;
    }

    public static List<IBase> getIncludeConcepts(FhirContext fhirContext, IBaseResource valueSet) {
        List<IBase> includes = ValueSetUtil.getIncludes(fhirContext, valueSet);
        if (includes == null) {
            return null;
        }
        BaseRuntimeChildDefinition conceptChild = ValueSetUtil.getIncludeConceptDefinition(fhirContext);
        ArrayList<IBase> concepts = new ArrayList<IBase>();
        for (IBase include : includes) {
            List currentConcepts = conceptChild.getAccessor().getValues(include);
            if (currentConcepts == null) continue;
            concepts.addAll(currentConcepts);
        }
        return concepts;
    }

    public static List<IBase> getExcludeConcepts(FhirContext fhirContext, IBaseResource valueSet) {
        List<IBase> excludes = ValueSetUtil.getExcludes(fhirContext, valueSet);
        if (excludes == null) {
            return null;
        }
        BaseRuntimeChildDefinition conceptChild = ValueSetUtil.getExcludeConceptDefinition(fhirContext);
        ArrayList<IBase> concepts = new ArrayList<IBase>();
        for (IBase exclude : excludes) {
            List currentConcepts = conceptChild.getAccessor().getValues(exclude);
            if (currentConcepts == null) continue;
            concepts.addAll(currentConcepts);
        }
        return concepts;
    }

    public static IBase getExpansion(FhirContext fhirContext, IBaseResource valueSet) {
        BaseRuntimeChildDefinition expansionChild = ValueSetUtil.getExpansionDefinition(fhirContext);
        List expansion = expansionChild.getAccessor().getValues((IBase)valueSet);
        if (expansion == null || expansion.isEmpty()) {
            return null;
        }
        if (expansion.size() > 1) {
            throw new IllegalArgumentException("ValueSet has multiple expansion definitions.");
        }
        return (IBase)expansion.get(0);
    }

    public static List<IBase> getContains(FhirContext fhirContext, IBaseResource valueSet) {
        IBase expansion = ValueSetUtil.getExpansion(fhirContext, valueSet);
        if (expansion == null) {
            return null;
        }
        BaseRuntimeChildDefinition containsDefinition = ValueSetUtil.getContainsDefinition(fhirContext);
        List contains = containsDefinition.getAccessor().getValues(expansion);
        if (contains == null || contains.isEmpty()) {
            return null;
        }
        return contains;
    }

    public static Iterable<Code> getCodesInCompose(FhirContext fhirContext, IBaseResource valueSet) {
        List<IBase> includes = ValueSetUtil.getIncludes(fhirContext, valueSet);
        if (includes == null) {
            return null;
        }
        BaseRuntimeChildDefinition conceptChild = ValueSetUtil.getIncludeConceptDefinition(fhirContext);
        BaseRuntimeChildDefinition.IAccessor versionAccessor = ValueSetUtil.getIncludeVersionDefinition(fhirContext).getAccessor();
        BaseRuntimeChildDefinition.IAccessor systemAccessor = ValueSetUtil.getIncludeSystemDefinition(fhirContext).getAccessor();
        BaseRuntimeChildDefinition.IAccessor codeAccessor = ValueSetUtil.getIncludeConceptCodeDefinition(fhirContext).getAccessor();
        BaseRuntimeChildDefinition.IAccessor displayAccessor = ValueSetUtil.getIncludeConceptDisplayDefinition(fhirContext).getAccessor();
        ArrayList<Code> codes = new ArrayList<Code>();
        for (IBase include : includes) {
            String version = ValueSetUtil.getStringValueFromPrimitiveAccessor(include, versionAccessor);
            String system = ValueSetUtil.getStringValueFromPrimitiveAccessor(include, systemAccessor);
            List concepts = conceptChild.getAccessor().getValues(include);
            for (IBase c : concepts) {
                String code = ValueSetUtil.getStringValueFromPrimitiveAccessor(c, codeAccessor);
                String display = ValueSetUtil.getStringValueFromPrimitiveAccessor(c, displayAccessor);
                codes.add(new Code().withSystem(system).withCode(code).withDisplay(display).withVersion(version));
            }
        }
        return codes;
    }

    public static Iterable<Code> getCodesInExpansion(FhirContext fhirContext, IBaseResource valueSet) {
        List<IBase> contains = ValueSetUtil.getContains(fhirContext, valueSet);
        if (contains == null) {
            return null;
        }
        BaseRuntimeChildDefinition.IAccessor systemAccessor = ValueSetUtil.getSystemDefinition(fhirContext).getAccessor();
        BaseRuntimeChildDefinition.IAccessor codeAccessor = ValueSetUtil.getCodeDefinition(fhirContext).getAccessor();
        BaseRuntimeChildDefinition.IAccessor displayAccessor = ValueSetUtil.getDisplayDefinition(fhirContext).getAccessor();
        BaseRuntimeChildDefinition.IAccessor versionAccessor = ValueSetUtil.getVersionDefinition(fhirContext).getAccessor();
        ArrayList<Code> codes = new ArrayList<Code>();
        for (IBase c : contains) {
            String system = ValueSetUtil.getStringValueFromPrimitiveAccessor(c, systemAccessor);
            String code = ValueSetUtil.getStringValueFromPrimitiveAccessor(c, codeAccessor);
            String display = ValueSetUtil.getStringValueFromPrimitiveAccessor(c, displayAccessor);
            String version = ValueSetUtil.getStringValueFromPrimitiveAccessor(c, versionAccessor);
            codes.add(new Code().withSystem(system).withCode(code).withDisplay(display).withVersion(version));
        }
        return codes;
    }

    public static String getUrl(FhirContext fhirContext, IBaseResource valueSet) {
        BaseRuntimeChildDefinition urlDef = ValueSetUtil.getUrlDefinition(fhirContext);
        return ValueSetUtil.getStringValueFromPrimitiveAccessor((IBase)valueSet, urlDef.getAccessor());
    }

    public static String getId(FhirContext fhirContext, IBaseResource valueSet) {
        BaseRuntimeChildDefinition idDef = ValueSetUtil.getIdDefinition(fhirContext);
        return ValueSetUtil.getStringValueFromPrimitiveAccessor((IBase)valueSet, idDef.getAccessor());
    }

    public static String getResourceType(FhirContext fhirContext, IBaseResource resource) {
        RuntimeResourceDefinition def = fhirContext.getResourceDefinition(resource);
        return def.getName();
    }

    private static String getStringValueFromPrimitiveAccessor(IBase value, BaseRuntimeChildDefinition.IAccessor accessor) {
        if (value == null || accessor == null) {
            return null;
        }
        List values = accessor.getValues(value);
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values.size() > 1) {
            throw new IllegalArgumentException("More than one value returned while attempting to access primitive value.");
        }
        IBase baseValue = (IBase)values.get(0);
        if (!(baseValue instanceof IPrimitiveType)) {
            throw new IllegalArgumentException("Non-primitive value encountered while trying to access primitive value.");
        }
        return ((IPrimitiveType)baseValue).getValueAsString();
    }

    private static BaseRuntimeChildDefinition getComposeDefinition(FhirContext fhirContext) {
        RuntimeResourceDefinition def = fhirContext.getResourceDefinition("ValueSet");
        return def.getChildByName("compose");
    }

    private static BaseRuntimeChildDefinition getIncludeDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition composeChild = ValueSetUtil.getComposeDefinition(fhirContext);
        return ValueSetUtil.getIncludeDefinition(composeChild);
    }

    private static BaseRuntimeChildDefinition getIncludeDefinition(BaseRuntimeChildDefinition composeChild) {
        RuntimeResourceBlockDefinition composeBlockChild = (RuntimeResourceBlockDefinition)composeChild.getChildByName("compose");
        BaseRuntimeChildDefinition includeChild = composeBlockChild.getChildByName("include");
        return includeChild;
    }

    private static BaseRuntimeChildDefinition getIncludeConceptDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition includeChild = ValueSetUtil.getIncludeDefinition(fhirContext);
        RuntimeResourceBlockDefinition includeBlockChild = (RuntimeResourceBlockDefinition)includeChild.getChildByName("include");
        return ValueSetUtil.getConceptDefinition(includeBlockChild);
    }

    private static RuntimeChildResourceBlockDefinition getConceptDefinition(RuntimeResourceBlockDefinition includeOrExcludeChild) {
        return (RuntimeChildResourceBlockDefinition)includeOrExcludeChild.getChildByName("concept");
    }

    private static BaseRuntimeChildDefinition getExcludeDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition composeChild = ValueSetUtil.getComposeDefinition(fhirContext);
        return ValueSetUtil.getExcludeDefinition(composeChild);
    }

    private static BaseRuntimeChildDefinition getExcludeDefinition(BaseRuntimeChildDefinition composeChild) {
        RuntimeResourceBlockDefinition composeBlockChild = (RuntimeResourceBlockDefinition)composeChild.getChildByName("compose");
        BaseRuntimeChildDefinition excludeChild = composeBlockChild.getChildByName("exclude");
        return excludeChild;
    }

    private static BaseRuntimeChildDefinition getExcludeConceptDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition excludeChild = ValueSetUtil.getExcludeDefinition(fhirContext);
        RuntimeResourceBlockDefinition excludeBlockChild = (RuntimeResourceBlockDefinition)excludeChild.getChildByName("exclude");
        return ValueSetUtil.getConceptDefinition(excludeBlockChild);
    }

    private static BaseRuntimeChildDefinition getExpansionDefinition(FhirContext fhirContext) {
        RuntimeResourceDefinition def = fhirContext.getResourceDefinition("ValueSet");
        return def.getChildByName("expansion");
    }

    private static BaseRuntimeChildDefinition getContainsDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition expansionChild = ValueSetUtil.getExpansionDefinition(fhirContext);
        RuntimeResourceBlockDefinition expansionBlockChild = (RuntimeResourceBlockDefinition)expansionChild.getChildByName("expansion");
        return ValueSetUtil.getContainsDefinition(expansionBlockChild);
    }

    private static BaseRuntimeChildDefinition getContainsDefinition(RuntimeResourceBlockDefinition expansionChild) {
        return expansionChild.getChildByName("contains");
    }

    private static BaseRuntimeChildDefinition getSystemDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition containsDefinition = ValueSetUtil.getContainsDefinition(fhirContext);
        RuntimeResourceBlockDefinition containsBlockDefinition = (RuntimeResourceBlockDefinition)containsDefinition.getChildByName("contains");
        return containsBlockDefinition.getChildByName("system");
    }

    private static BaseRuntimeChildDefinition getVersionDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition containsDefinition = ValueSetUtil.getContainsDefinition(fhirContext);
        RuntimeResourceBlockDefinition containsBlockDefinition = (RuntimeResourceBlockDefinition)containsDefinition.getChildByName("contains");
        return containsBlockDefinition.getChildByName("version");
    }

    private static BaseRuntimeChildDefinition getCodeDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition containsDefinition = ValueSetUtil.getContainsDefinition(fhirContext);
        RuntimeResourceBlockDefinition containsBlockDefinition = (RuntimeResourceBlockDefinition)containsDefinition.getChildByName("contains");
        return containsBlockDefinition.getChildByName("code");
    }

    private static BaseRuntimeChildDefinition getDisplayDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition containsDefinition = ValueSetUtil.getContainsDefinition(fhirContext);
        RuntimeResourceBlockDefinition containsBlockDefinition = (RuntimeResourceBlockDefinition)containsDefinition.getChildByName("contains");
        return containsBlockDefinition.getChildByName("display");
    }

    private static BaseRuntimeChildDefinition getIncludeConceptCodeDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition includeConceptDefinition = ValueSetUtil.getIncludeConceptDefinition(fhirContext);
        RuntimeResourceBlockDefinition containsBlockDefinition = (RuntimeResourceBlockDefinition)includeConceptDefinition.getChildByName("concept");
        return containsBlockDefinition.getChildByName("code");
    }

    private static BaseRuntimeChildDefinition getIncludeConceptDisplayDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition includeConceptDefinition = ValueSetUtil.getIncludeConceptDefinition(fhirContext);
        RuntimeResourceBlockDefinition containsBlockDefinition = (RuntimeResourceBlockDefinition)includeConceptDefinition.getChildByName("concept");
        return containsBlockDefinition.getChildByName("display");
    }

    private static BaseRuntimeChildDefinition getIncludeSystemDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition includeDefinition = ValueSetUtil.getIncludeDefinition(fhirContext);
        RuntimeResourceBlockDefinition includeBlockDefinition = (RuntimeResourceBlockDefinition)includeDefinition.getChildByName("include");
        return includeBlockDefinition.getChildByName("system");
    }

    private static BaseRuntimeChildDefinition getIncludeVersionDefinition(FhirContext fhirContext) {
        BaseRuntimeChildDefinition includeDefinition = ValueSetUtil.getIncludeDefinition(fhirContext);
        RuntimeResourceBlockDefinition includeBlockDefinition = (RuntimeResourceBlockDefinition)includeDefinition.getChildByName("include");
        return includeBlockDefinition.getChildByName("version");
    }

    private static BaseRuntimeChildDefinition getUrlDefinition(FhirContext fhirContext) {
        RuntimeResourceDefinition def = fhirContext.getResourceDefinition("ValueSet");
        return def.getChildByName("url");
    }

    private static BaseRuntimeChildDefinition getIdDefinition(FhirContext fhirContext) {
        RuntimeResourceDefinition def = fhirContext.getResourceDefinition("ValueSet");
        return def.getChildByName("id");
    }
}

