/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.engine.terminology;

import java.util.HashMap;
import java.util.Map;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.terminology.CodeSystemInfo;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;

public class PrivateCachingTerminologyProviderDecorator
implements TerminologyProvider {
    private Map<String, Iterable<Code>> valueSetIndexById = new HashMap<String, Iterable<Code>>();
    private TerminologyProvider innerProvider;

    public PrivateCachingTerminologyProviderDecorator(TerminologyProvider terminologyProvider) {
        this.innerProvider = terminologyProvider;
    }

    public boolean in(Code code, ValueSetInfo valueSet) {
        Iterable<Code> codes;
        if (!this.valueSetIndexById.containsKey(valueSet.getId())) {
            this.expand(valueSet);
        }
        if ((codes = this.valueSetIndexById.get(valueSet.getId())) == null) {
            return false;
        }
        for (Code c : codes) {
            if (!c.getCode().equals(code.getCode()) || !c.getSystem().equals(code.getSystem())) continue;
            return true;
        }
        return false;
    }

    public Iterable<Code> expand(ValueSetInfo valueSet) {
        if (!this.valueSetIndexById.containsKey(valueSet.getId())) {
            this.valueSetIndexById.put(valueSet.getId(), this.innerProvider.expand(valueSet));
        }
        return this.valueSetIndexById.get(valueSet.getId());
    }

    public Code lookup(Code code, CodeSystemInfo codeSystem) {
        return this.innerProvider.lookup(code, codeSystem);
    }
}

