/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.engine.terminology;

import java.util.List;
import java.util.Objects;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.terminology.CodeSystemInfo;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityTerminologyProvider
implements TerminologyProvider {
    Logger logger = LoggerFactory.getLogger(PriorityTerminologyProvider.class);
    List<TerminologyProvider> terminologyProviders;

    public PriorityTerminologyProvider(List<TerminologyProvider> terminologyProviders) {
        this.terminologyProviders = Objects.requireNonNull(terminologyProviders, "terminologyProviders can not be null");
    }

    public boolean in(Code code, ValueSetInfo valueSet) {
        for (TerminologyProvider terminologyProvider : this.terminologyProviders) {
            try {
                boolean in = terminologyProvider.in(code, valueSet);
                if (!in) continue;
                return true;
            }
            catch (Exception e) {
                this.logger.warn("inner provider threw an Exception, continuing: %s", (Object)e.getMessage());
            }
        }
        return false;
    }

    public Iterable<Code> expand(ValueSetInfo valueSet) {
        return this.terminologyProviders.stream().map(x -> x.expand(valueSet)).findFirst().orElseGet(null);
    }

    public Code lookup(Code code, CodeSystemInfo codeSystem) {
        return this.terminologyProviders.stream().map(x -> x.lookup(code, codeSystem)).findFirst().orElseGet(null);
    }
}

