/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.engine.retrieve;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.util.BundleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.retrieve.TerminologyAwareRetrieveProvider;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;
import org.opencds.cqf.cql.evaluator.engine.util.CodeUtil;
import org.opencds.cqf.cql.evaluator.fhir.util.FhirPathCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleRetrieveProvider
extends TerminologyAwareRetrieveProvider {
    private static final Logger logger = LoggerFactory.getLogger(BundleRetrieveProvider.class);
    private final IBaseBundle bundle;
    private final FhirContext fhirContext;
    private final CodeUtil codeUtil;
    private final IFhirPath fhirPath;

    public BundleRetrieveProvider(FhirContext fhirContext, IBaseBundle bundle) {
        this.fhirContext = Objects.requireNonNull(fhirContext, "bundle can not be null.");
        this.bundle = Objects.requireNonNull(bundle, "bundle can not be null.");
        this.codeUtil = new CodeUtil(fhirContext);
        this.fhirPath = FhirPathCache.cachedForContext((FhirContext)fhirContext);
    }

    public Iterable<Object> retrieve(String context, String contextPath, Object contextValue, String dataType, String templateId, String codePath, Iterable<Code> codes, String valueSet, String datePath, String dateLowPath, String dateHighPath, Interval dateRange) {
        List<? extends IBaseResource> resources = BundleUtil.toListOfResourcesOfType((FhirContext)this.fhirContext, (IBaseBundle)this.bundle, (Class)this.fhirContext.getResourceDefinition(dataType).getImplementingClass());
        resources = this.filterToContext(dataType, context, contextPath, contextValue, resources);
        resources = this.filterToTerminology(dataType, codePath, codes, valueSet, resources);
        return resources.stream().map(x -> x).collect(Collectors.toList());
    }

    private boolean anyCodeMatch(Iterable<Code> left, Iterable<Code> right) {
        if (left == null || right == null) {
            return false;
        }
        for (Code code : left) {
            for (Code otherCode : right) {
                if (code.getCode() == null || !code.getCode().equals(otherCode.getCode()) || code.getSystem() == null || !code.getSystem().equals(otherCode.getSystem())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean anyCodeInValueSet(Iterable<Code> codes, String valueSet) {
        if (codes == null || valueSet == null) {
            return false;
        }
        if (this.terminologyProvider == null) {
            throw new IllegalStateException(String.format("Unable to check code membership for in ValueSet %s. terminologyProvider is null.", valueSet));
        }
        ValueSetInfo valueSetInfo = new ValueSetInfo().withId(valueSet);
        for (Code code : codes) {
            if (!this.terminologyProvider.in(code, valueSetInfo)) continue;
            return true;
        }
        return false;
    }

    private boolean isPrimitiveMatch(String dataType, IPrimitiveType<?> code, Iterable<Code> codes) {
        if (code == null || codes == null) {
            return false;
        }
        String primitiveString = code.getValueAsString().replace(dataType + "/", "");
        for (Code c : codes) {
            String s;
            if (!(c instanceof String) || !(s = (String)c).equals(primitiveString)) continue;
            return true;
        }
        return false;
    }

    private List<? extends IBaseResource> filterToTerminology(String dataType, String codePath, Iterable<Code> codes, String valueSet, List<? extends IBaseResource> resources) {
        if (codes == null && valueSet == null) {
            return resources;
        }
        if (codePath == null) {
            return resources;
        }
        ArrayList<IBaseResource> filtered = new ArrayList<IBaseResource>();
        for (IBaseResource iBaseResource : resources) {
            List values = this.fhirPath.evaluate((IBase)iBaseResource, codePath, IBase.class);
            if (values != null && values.size() == 1 && values.get(0) instanceof IPrimitiveType) {
                if (!this.isPrimitiveMatch(dataType, (IPrimitiveType)values.get(0), codes)) continue;
                filtered.add(iBaseResource);
                continue;
            }
            List<Code> resourceCodes = this.codeUtil.getElmCodesFromObject(values);
            if (resourceCodes == null) continue;
            if (this.anyCodeMatch(resourceCodes, codes)) {
                filtered.add(iBaseResource);
                continue;
            }
            if (!this.anyCodeInValueSet(resourceCodes, valueSet)) continue;
            filtered.add(iBaseResource);
        }
        return filtered;
    }

    private List<? extends IBaseResource> filterToContext(String dataType, String context, String contextPath, Object contextValue, List<? extends IBaseResource> resources) {
        if (context == null || contextValue == null || contextPath == null) {
            logger.info("Unable to relate {} to {} context with contextPath: {} and contextValue: {}. Returning all resources.", new Object[]{dataType, context, contextPath, contextValue});
            return resources;
        }
        ArrayList<IBaseResource> filtered = new ArrayList<IBaseResource>();
        for (IBaseResource iBaseResource : resources) {
            String id;
            Optional resContextValue = this.fhirPath.evaluateFirst((IBase)iBaseResource, contextPath, IBase.class);
            if (resContextValue.isPresent() && resContextValue.get() instanceof IIdType) {
                id = ((IIdType)resContextValue.get()).getIdPart();
                if (id == null) {
                    logger.debug("Found null id for {} resource. Skipping.", (Object)dataType);
                    continue;
                }
                if (id.startsWith("urn:")) {
                    logger.debug("Found {} with urn: prefix. Stripping.", (Object)dataType);
                    id = this.stripUrnScheme(id);
                }
                if (!id.equals(contextValue)) {
                    logger.debug("Found {} with id  {}. Skipping.", (Object)dataType, (Object)id);
                    continue;
                }
            } else if (resContextValue.isPresent() && resContextValue.get() instanceof IBaseReference) {
                id = ((IBaseReference)resContextValue.get()).getReferenceElement().getValue();
                if (id == null) {
                    logger.debug("Found null reference for {} resource. Skipping.", (Object)dataType);
                    continue;
                }
                if (id.startsWith("urn:")) {
                    logger.debug("Found reference with urn: prefix. Stripping.", (Object)dataType);
                    id = this.stripUrnScheme(id);
                }
                if (id.contains("/")) {
                    id = id.split("/")[1];
                }
                if (!id.equals(contextValue)) {
                    logger.info("Found {} with id  {}. Skipping.", (Object)dataType, (Object)id);
                    continue;
                }
            } else {
                Optional reference = this.fhirPath.evaluateFirst((IBase)iBaseResource, "reference", IBase.class);
                if (!reference.isPresent()) {
                    logger.info("Found {} resource unrelated to context. Skipping.", (Object)dataType);
                    continue;
                }
                String referenceString = ((IPrimitiveType)reference.get()).getValueAsString();
                if (referenceString.startsWith("urn:")) {
                    logger.debug("Found reference with urn: prefix. Stripping.", (Object)dataType);
                    referenceString = this.stripUrnScheme(referenceString);
                }
                if (referenceString.contains("/")) {
                    referenceString = referenceString.substring(referenceString.indexOf("/") + 1, referenceString.length());
                }
                if (!referenceString.equals((String)contextValue)) {
                    logger.info("Found {} resource for context value: {} when expecting: {}. Skipping.", new Object[]{dataType, referenceString, (String)contextValue});
                    continue;
                }
            }
            filtered.add(iBaseResource);
        }
        return filtered;
    }

    private String stripUrnScheme(String uri) {
        if (uri.startsWith("urn:uuid:")) {
            return uri.substring(9);
        }
        if (uri.startsWith("urn:oid:")) {
            return uri.substring(8);
        }
        return uri;
    }
}

