/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.engine.model;

import java.util.HashMap;
import java.util.Map;
import org.opencds.cqf.cql.engine.model.ModelResolver;

public class CachingModelResolverDecorator
implements ModelResolver {
    private static Map<String, Map<String, Map<String, Object>>> perPackageContextResolutions = new HashMap<String, Map<String, Map<String, Object>>>();
    private static Map<String, Map<String, Class<?>>> perPackageTypeResolutionsByTypeName = new HashMap();
    private static Map<String, Map<Class<?>, Class<?>>> perPackageTypeResolutionsByClass = new HashMap();
    private ModelResolver innerResolver;

    public CachingModelResolverDecorator(ModelResolver modelResolver) {
        this.innerResolver = modelResolver;
    }

    public String getPackageName() {
        return this.innerResolver.getPackageName();
    }

    public void setPackageName(String packageName) {
        this.innerResolver.setPackageName(packageName);
    }

    public Object resolvePath(Object target, String path) {
        return this.innerResolver.resolvePath(target, path);
    }

    public Object getContextPath(String contextType, String targetType) {
        Map<String, Object> contextTypeResolutions;
        Map<String, Map<String, Object>> packageContextResolutions;
        if (!perPackageContextResolutions.containsKey(this.getPackageName())) {
            perPackageContextResolutions.put(this.getPackageName(), new HashMap());
        }
        if (!(packageContextResolutions = perPackageContextResolutions.get(this.getPackageName())).containsKey(contextType)) {
            packageContextResolutions.put(contextType, new HashMap());
        }
        if (!(contextTypeResolutions = packageContextResolutions.get(contextType)).containsKey(targetType)) {
            contextTypeResolutions.put(targetType, this.innerResolver.getContextPath(contextType, targetType));
        }
        return contextTypeResolutions.get(targetType);
    }

    public Class<?> resolveType(String typeName) {
        Map<String, Class<?>> packageTypeResolutions;
        if (!perPackageTypeResolutionsByTypeName.containsKey(this.getPackageName())) {
            perPackageTypeResolutionsByTypeName.put(this.getPackageName(), new HashMap());
        }
        if (!(packageTypeResolutions = perPackageTypeResolutionsByTypeName.get(this.getPackageName())).containsKey(typeName)) {
            packageTypeResolutions.put(typeName, this.innerResolver.resolveType(typeName));
        }
        return packageTypeResolutions.get(typeName);
    }

    public Class<?> resolveType(Object value) {
        Class<?> valueClass;
        Map<Class<?>, Class<?>> packageTypeResolutions;
        if (!perPackageTypeResolutionsByClass.containsKey(this.getPackageName())) {
            perPackageTypeResolutionsByClass.put(this.getPackageName(), new HashMap());
        }
        if (!(packageTypeResolutions = perPackageTypeResolutionsByClass.get(this.getPackageName())).containsKey(valueClass = value.getClass())) {
            packageTypeResolutions.put(valueClass, this.innerResolver.resolveType(value));
        }
        return packageTypeResolutions.get(valueClass);
    }

    public Object createInstance(String typeName) {
        return this.innerResolver.createInstance(typeName);
    }

    public void setValue(Object target, String path, Object value) {
        this.innerResolver.setValue(target, path, value);
    }

    public Boolean objectEqual(Object left, Object right) {
        return this.innerResolver.objectEqual(left, right);
    }

    public Boolean objectEquivalent(Object left, Object right) {
        return this.innerResolver.objectEquivalent(left, right);
    }

    public Boolean is(Object value, Class<?> type) {
        return this.innerResolver.is(value, type);
    }

    public Object as(Object value, Class<?> type, boolean isStrict) {
        return this.innerResolver.as(value, type, isStrict);
    }

    public ModelResolver getInnerResolver() {
        return this.innerResolver;
    }
}

