/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.engine.execution;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.cqframework.cql.cql2elm.CqlTranslator;
import org.cqframework.cql.cql2elm.CqlTranslatorOptions;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.model.TranslatedLibrary;
import org.cqframework.cql.cql2elm.model.serialization.LibraryWrapper;
import org.hl7.cql_annotations.r1.Annotation;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.ObjectFactory;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.engine.execution.CqlLibraryReader;
import org.opencds.cqf.cql.engine.execution.JsonCqlLibraryReader;
import org.opencds.cqf.cql.evaluator.converter.VersionedIdentifierConverter;
import org.opencds.cqf.cql.evaluator.cql2elm.content.LibraryContentProvider;
import org.opencds.cqf.cql.evaluator.cql2elm.content.LibraryContentType;
import org.opencds.cqf.cql.evaluator.engine.elm.LibraryMapper;
import org.opencds.cqf.cql.evaluator.engine.execution.TranslatorOptionAwareLibraryLoader;
import org.opencds.cqf.cql.evaluator.engine.util.TranslatorOptionsUtil;

public class TranslatingLibraryLoader
implements TranslatorOptionAwareLibraryLoader {
    protected static JAXBContext jaxbContext;
    protected static Marshaller marshaller;
    protected static ObjectMapper objectMapper;
    protected CqlTranslatorOptions cqlTranslatorOptions;
    protected List<LibraryContentProvider> libraryContentProviders;
    protected LibraryManager libraryManager;

    public TranslatingLibraryLoader(ModelManager modelManager, List<LibraryContentProvider> libraryContentProviders, CqlTranslatorOptions translatorOptions) {
        this.libraryContentProviders = Objects.requireNonNull(libraryContentProviders, "libraryContentProviders can not be null");
        this.cqlTranslatorOptions = translatorOptions != null ? translatorOptions : CqlTranslatorOptions.defaultOptions();
        this.libraryManager = new LibraryManager(modelManager);
        for (LibraryContentProvider provider : libraryContentProviders) {
            this.libraryManager.getLibrarySourceLoader().registerProvider((LibrarySourceProvider)provider);
        }
    }

    public org.cqframework.cql.elm.execution.Library load(org.cqframework.cql.elm.execution.VersionedIdentifier libraryIdentifier) {
        org.cqframework.cql.elm.execution.Library library = this.getLibraryFromElm(libraryIdentifier);
        if (library != null && this.translatorOptionsMatch(library).booleanValue()) {
            return library;
        }
        return this.translate(libraryIdentifier);
    }

    @Override
    public CqlTranslatorOptions getCqlTranslatorOptions() {
        return this.cqlTranslatorOptions;
    }

    protected org.cqframework.cql.elm.execution.Library getLibraryFromElm(org.cqframework.cql.elm.execution.VersionedIdentifier libraryIdentifier) {
        VersionedIdentifier versionedIdentifier = VersionedIdentifierConverter.toElmIdentifier((org.cqframework.cql.elm.execution.VersionedIdentifier)libraryIdentifier);
        InputStream content = this.getLibraryContent(versionedIdentifier, LibraryContentType.JXSON);
        if (content != null) {
            try {
                return this.readJxson(content);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((content = this.getLibraryContent(versionedIdentifier, LibraryContentType.XML)) != null) {
            try {
                return this.readXml(content);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected Boolean translatorOptionsMatch(org.cqframework.cql.elm.execution.Library library) {
        EnumSet<CqlTranslator.Options> options = TranslatorOptionsUtil.getTranslatorOptions(library);
        if (options == null) {
            return false;
        }
        return options.equals(this.cqlTranslatorOptions.getOptions());
    }

    protected InputStream getLibraryContent(VersionedIdentifier libraryIdentifier, LibraryContentType libraryContentType) {
        for (LibraryContentProvider libraryContentProvider : this.libraryContentProviders) {
            InputStream content = libraryContentProvider.getLibraryContent(libraryIdentifier, libraryContentType);
            if (content == null) continue;
            return content;
        }
        return null;
    }

    protected org.cqframework.cql.elm.execution.Library translate(org.cqframework.cql.elm.execution.VersionedIdentifier libraryIdentifier) {
        try {
            ArrayList errors = new ArrayList();
            TranslatedLibrary library = this.libraryManager.resolveLibrary(VersionedIdentifierConverter.toElmIdentifier((org.cqframework.cql.elm.execution.VersionedIdentifier)libraryIdentifier), this.cqlTranslatorOptions, errors);
            return LibraryMapper.INSTANCE.map(library.getLibrary());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected synchronized org.cqframework.cql.elm.execution.Library readJxson(String json) throws IOException, JAXBException {
        return this.readJxson(new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)));
    }

    protected synchronized org.cqframework.cql.elm.execution.Library readJxson(InputStream inputStream) throws IOException {
        return JsonCqlLibraryReader.read((Reader)new InputStreamReader(inputStream));
    }

    protected synchronized org.cqframework.cql.elm.execution.Library readXml(InputStream inputStream) throws IOException, JAXBException {
        return CqlLibraryReader.read((InputStream)inputStream);
    }

    protected synchronized org.cqframework.cql.elm.execution.Library readXml(String xml) throws IOException, JAXBException {
        return this.readXml(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    protected synchronized String toXml(Library library) {
        try {
            return this.convertToXml(library);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Could not convert library to XML.", e);
        }
    }

    protected synchronized String toJxson(Library library) {
        try {
            return this.convertToJxson(library);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not convert library to JXSON.", e);
        }
    }

    protected synchronized String convertToXml(Library library) throws JAXBException {
        StringWriter writer = new StringWriter();
        this.getMarshaller().marshal((Object)new ObjectFactory().createLibrary(library), (Writer)writer);
        return writer.getBuffer().toString();
    }

    protected synchronized Marshaller getMarshaller() throws JAXBException {
        if (marshaller == null) {
            marshaller = this.getJaxbContext().createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
        }
        return marshaller;
    }

    protected synchronized JAXBContext getJaxbContext() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Library.class, Annotation.class});
        }
        return jaxbContext;
    }

    protected synchronized ObjectMapper getJxsonMapper() {
        if (objectMapper == null) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_DEFAULT);
            mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            JaxbAnnotationModule annotationModule = new JaxbAnnotationModule();
            mapper.registerModule((Module)annotationModule);
            objectMapper = mapper;
        }
        return objectMapper;
    }

    public String convertToJxson(Library library) throws JsonProcessingException {
        LibraryWrapper wrapper = new LibraryWrapper();
        wrapper.setLibrary(library);
        return this.getJxsonMapper().writeValueAsString((Object)wrapper);
    }
}

