/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.cql2elm.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.cqframework.cql.cql2elm.ModelInfoLoader;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.model.Model;
import org.cqframework.cql.cql2elm.model.SystemModel;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class CacheAwareModelManager
extends ModelManager {
    private final Map<VersionedIdentifier, Model> globalCache;
    private final Map<String, Model> localCache;
    private final ModelInfoLoader modelInfoLoader;

    public CacheAwareModelManager(Map<VersionedIdentifier, Model> globalCache) {
        Objects.requireNonNull(globalCache, "globalCache can not be null.");
        this.globalCache = globalCache;
        this.localCache = new HashMap<String, Model>();
        this.modelInfoLoader = new ModelInfoLoader();
    }

    private Model buildModel(VersionedIdentifier identifier) {
        Object model = null;
        try {
            ModelInfo modelInfo = this.modelInfoLoader.getModelInfo(identifier);
            model = identifier.getId().equals("System") ? new SystemModel(modelInfo) : new Model(modelInfo, (ModelManager)this);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not load model information for model %s, version %s.", identifier.getId(), identifier.getVersion()));
        }
        return model;
    }

    public Model resolveModel(VersionedIdentifier modelIdentifier) {
        Model model = null;
        if (this.localCache.containsKey(modelIdentifier.getId())) {
            model = this.localCache.get(modelIdentifier.getId());
            if (modelIdentifier.getVersion() != null && !modelIdentifier.getVersion().equals(model.getModelInfo().getVersion())) {
                throw new IllegalArgumentException(String.format("Could not load model information for model %s, version %s because version %s is already loaded.", modelIdentifier.getId(), modelIdentifier.getVersion(), model.getModelInfo().getVersion()));
            }
        }
        if (model == null && this.globalCache.containsKey(modelIdentifier)) {
            model = this.globalCache.get(modelIdentifier);
            this.localCache.put(modelIdentifier.getId(), model);
        }
        if (model == null) {
            model = this.buildModel(modelIdentifier);
            this.globalCache.put(modelIdentifier, model);
            this.localCache.put(modelIdentifier.getId(), model);
        }
        return model;
    }
}

