/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.cql2elm.content.fhir;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.opencds.cqf.cql.evaluator.cql2elm.content.LibraryContentProvider;
import org.opencds.cqf.cql.evaluator.cql2elm.content.LibraryContentType;
import org.opencds.cqf.cql.evaluator.fhir.adapter.AdapterFactory;
import org.opencds.cqf.cql.evaluator.fhir.adapter.AttachmentAdapter;
import org.opencds.cqf.cql.evaluator.fhir.adapter.LibraryAdapter;

public abstract class BaseFhirLibraryContentProvider
implements LibraryContentProvider {
    protected AdapterFactory adapterFactory;

    public BaseFhirLibraryContentProvider(AdapterFactory adapterFactory) {
        this.adapterFactory = Objects.requireNonNull(adapterFactory, "adapterFactory can not be null");
    }

    @Override
    public InputStream getLibraryContent(VersionedIdentifier libraryIdentifier, LibraryContentType libraryContentType) {
        Objects.requireNonNull(libraryIdentifier, "versionedIdentifier can not be null.");
        Objects.requireNonNull(libraryContentType, "libraryContentType can not be null.");
        IBaseResource library = this.getLibrary(libraryIdentifier);
        if (library == null) {
            return null;
        }
        switch (libraryContentType) {
            case CQL: {
                return this.getContentStream(library, "text/cql");
            }
            case XML: {
                return this.getContentStream(library, "application/elm+xml");
            }
            case JXSON: 
            case JSON: {
                return this.getContentStream(library, "application/elm+json");
            }
        }
        throw new UnsupportedOperationException(String.format("This content provider does not support the %s LibraryContentType", libraryContentType.toString()));
    }

    protected InputStream getContentStream(IBaseResource library, String contentType) {
        LibraryAdapter libraryAdapter = this.adapterFactory.createLibrary(library);
        if (libraryAdapter.hasContent().booleanValue()) {
            for (ICompositeType attachment : libraryAdapter.getContent()) {
                AttachmentAdapter attachmentAdapter = this.adapterFactory.createAttachment(attachment);
                if (!attachmentAdapter.getContentType().equals(contentType)) continue;
                return new ByteArrayInputStream(attachmentAdapter.getData());
            }
        }
        return null;
    }

    protected abstract IBaseResource getLibrary(VersionedIdentifier var1);
}

