/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.cql2elm.content;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.evaluator.cql2elm.content.LibraryContentProvider;
import org.opencds.cqf.cql.evaluator.cql2elm.content.LibraryContentType;

public class InMemoryLibraryContentProvider
implements LibraryContentProvider {
    private List<String> libraries;

    public InMemoryLibraryContentProvider(List<String> libraries) {
        this.libraries = libraries;
    }

    @Override
    public InputStream getLibrarySource(VersionedIdentifier libraryIdentifier) {
        String id = libraryIdentifier.getId();
        String version = libraryIdentifier.getVersion();
        String matchText = "(?s).*library\\s+" + id;
        matchText = version != null ? matchText + "\\s+version\\s+'" + version + "'\\s+(?s).*" : matchText + "\\s+(?s).*";
        for (String library : this.libraries) {
            if (!library.matches(matchText)) continue;
            return new ByteArrayInputStream(library.getBytes());
        }
        return null;
    }

    @Override
    public InputStream getLibraryContent(VersionedIdentifier libraryIdentifier, LibraryContentType libraryContentType) {
        if (libraryContentType == LibraryContentType.CQL) {
            return this.getLibrarySource(libraryIdentifier);
        }
        return null;
    }
}

