/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.execution;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.cqframework.cql.elm.execution.ExpressionDef;
import org.cqframework.cql.elm.execution.FunctionDef;
import org.cqframework.cql.elm.execution.IncludeDef;
import org.cqframework.cql.elm.execution.Library;
import org.cqframework.cql.elm.execution.VersionedIdentifier;
import org.opencds.cqf.cql.engine.data.DataProvider;
import org.opencds.cqf.cql.engine.debug.DebugMap;
import org.opencds.cqf.cql.engine.exception.CqlException;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.execution.EvaluationResult;
import org.opencds.cqf.cql.engine.execution.InMemoryLibraryLoader;
import org.opencds.cqf.cql.engine.execution.LibraryLoader;
import org.opencds.cqf.cql.engine.execution.NamespaceHelper;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;

public class CqlEngine {
    private LibraryLoader libraryLoader;
    private Map<String, DataProvider> dataProviders;
    private TerminologyProvider terminologyProvider;
    private EnumSet<Options> engineOptions;

    public CqlEngine(LibraryLoader libraryLoader) {
        this(libraryLoader, null, null, null);
    }

    public CqlEngine(LibraryLoader libraryLoader, Map<String, DataProvider> dataProviders, TerminologyProvider terminologyProvider) {
        this(libraryLoader, dataProviders, terminologyProvider, null);
    }

    public CqlEngine(LibraryLoader libraryLoader, EnumSet<Options> engineOptions) {
        this(libraryLoader, null, null, null);
    }

    public CqlEngine(LibraryLoader libraryLoader, Map<String, DataProvider> dataProviders, TerminologyProvider terminologyProvider, EnumSet<Options> engineOptions) {
        if (libraryLoader == null) {
            throw new IllegalArgumentException("libraryLoader can not be null.");
        }
        if (engineOptions == null) {
            engineOptions = EnumSet.of(Options.EnableExpressionCaching);
        }
        this.libraryLoader = libraryLoader;
        this.dataProviders = dataProviders;
        this.terminologyProvider = terminologyProvider;
        this.engineOptions = engineOptions;
    }

    public EvaluationResult evaluate(String libraryName) {
        return this.evaluate(libraryName, null, null, null);
    }

    public EvaluationResult evaluate(String libraryName, Set<String> expressions) {
        return this.evaluate(libraryName, expressions, null, null);
    }

    public EvaluationResult evaluate(String libraryName, Set<String> expressions, Pair<String, Object> contextParameter) {
        return this.evaluate(libraryName, expressions, contextParameter, null);
    }

    public EvaluationResult evaluate(String libraryName, Set<String> expressions, Map<String, Object> parameters) {
        return this.evaluate(libraryName, expressions, null, parameters);
    }

    public EvaluationResult evaluate(String libraryName, Pair<String, Object> contextParameter) {
        return this.evaluate(libraryName, null, contextParameter, null);
    }

    public EvaluationResult evaluate(String libraryName, Pair<String, Object> contextParameter, Map<String, Object> parameters) {
        return this.evaluate(libraryName, null, contextParameter, parameters);
    }

    public EvaluationResult evaluate(String libraryName, Map<String, Object> parameters) {
        return this.evaluate(libraryName, null, null, parameters);
    }

    public EvaluationResult evaluate(String libraryName, Set<String> expressions, Pair<String, Object> contextParameter, Map<String, Object> parameters) {
        return this.evaluate(new VersionedIdentifier().withId(libraryName), expressions, contextParameter, parameters, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier) {
        return this.evaluate(libraryIdentifier, null, null, null, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, Set<String> expressions) {
        return this.evaluate(libraryIdentifier, expressions, null, null, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, Set<String> expressions, Pair<String, Object> contextParameter) {
        return this.evaluate(libraryIdentifier, expressions, contextParameter, null, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, Set<String> expressions, Map<String, Object> parameters) {
        return this.evaluate(libraryIdentifier, expressions, null, parameters, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, Pair<String, Object> contextParameter) {
        return this.evaluate(libraryIdentifier, null, contextParameter, null, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, Pair<String, Object> contextParameter, Map<String, Object> parameters) {
        return this.evaluate(libraryIdentifier, null, contextParameter, parameters, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, Map<String, Object> parameters) {
        return this.evaluate(libraryIdentifier, null, null, parameters, null);
    }

    public EvaluationResult evaluate(VersionedIdentifier libraryIdentifier, Set<String> expressions, Pair<String, Object> contextParameter, Map<String, Object> parameters, DebugMap debugMap) {
        HashMap<VersionedIdentifier, Library> libraryCache = new HashMap<VersionedIdentifier, Library>();
        if (libraryIdentifier == null) {
            throw new IllegalArgumentException("libraryIdentifier can not be null.");
        }
        Library library = this.loadAndValidate(libraryCache, libraryIdentifier);
        if (expressions == null) {
            expressions = this.getExpressionSet(library);
        }
        Context context = this.initializeContext(libraryCache, library, debugMap);
        this.setParametersForContext(library, context, contextParameter, parameters);
        return this.evaluateExpressions(context, expressions);
    }

    private EvaluationResult evaluateExpressions(Context context, Set<String> expressions) {
        EvaluationResult result = new EvaluationResult();
        for (String expression : expressions) {
            ExpressionDef def = context.resolveExpressionRef(expression);
            if (def == null) {
                throw new CqlException(String.format("Unable to resolve expression \"%s.\"", expression));
            }
            if (def instanceof FunctionDef) continue;
            context.enterContext(def.getContext());
            Object object = def.evaluate(context);
            result.expressionResults.put(expression, object);
        }
        result.setDebugResult(context.getDebugResult());
        return result;
    }

    private void setParametersForContext(Library library, Context context, Pair<String, Object> contextParameter, Map<String, Object> parameters) {
        if (contextParameter != null) {
            context.setContextValue((String)contextParameter.getLeft(), contextParameter.getRight());
        }
        if (parameters != null) {
            for (Map.Entry<String, Object> parameterValue : parameters.entrySet()) {
                context.setParameter(library.getLocalId(), parameterValue.getKey(), parameterValue.getValue());
            }
            if (library.getIncludes() != null && library.getIncludes().getDef() != null) {
                for (IncludeDef def : library.getIncludes().getDef()) {
                    String name = def.getLocalIdentifier();
                    for (Map.Entry<String, Object> parameterValue : parameters.entrySet()) {
                        context.setParameter(name, parameterValue.getKey(), parameterValue.getValue());
                    }
                }
            }
        }
    }

    private Context initializeContext(Map<VersionedIdentifier, Library> libraryCache, Library library, DebugMap debugMap) {
        Context context = new Context(library);
        context.registerLibraryLoader(new InMemoryLibraryLoader(libraryCache.values()));
        if (this.engineOptions.contains((Object)Options.EnableExpressionCaching)) {
            context.setExpressionCaching(true);
        }
        if (this.terminologyProvider != null) {
            context.registerTerminologyProvider(this.terminologyProvider);
        }
        if (this.dataProviders != null) {
            for (Map.Entry<String, DataProvider> pair : this.dataProviders.entrySet()) {
                context.registerDataProvider(pair.getKey(), pair.getValue());
            }
        }
        context.setDebugMap(debugMap);
        return context;
    }

    private Library loadAndValidate(Map<VersionedIdentifier, Library> libraryCache, VersionedIdentifier libraryIdentifier) {
        if (libraryCache.containsKey(libraryIdentifier)) {
            return libraryCache.get(libraryIdentifier);
        }
        Library library = this.libraryLoader.load(libraryIdentifier);
        if (library == null) {
            throw new IllegalArgumentException(String.format("Unable to load library %s", libraryIdentifier.getId() + (libraryIdentifier.getVersion() != null ? "-" + libraryIdentifier.getVersion() : "")));
        }
        this.validateTerminologyRequirements(library);
        if (library.getIncludes() != null && library.getIncludes().getDef() != null) {
            for (IncludeDef include : library.getIncludes().getDef()) {
                this.loadAndValidate(libraryCache, new VersionedIdentifier().withSystem(NamespaceHelper.getUriPart(include.getPath())).withId(NamespaceHelper.getNamePart(include.getPath())).withVersion(include.getVersion()));
            }
        }
        libraryCache.put(libraryIdentifier, library);
        return library;
    }

    private void validateTerminologyRequirements(Library library) {
        if ((library.getCodeSystems() != null && library.getCodeSystems().getDef() != null && !library.getCodeSystems().getDef().isEmpty() || library.getCodes() != null && library.getCodes().getDef() != null && !library.getCodes().getDef().isEmpty() || library.getValueSets() != null && library.getValueSets().getDef() != null && !library.getValueSets().getDef().isEmpty()) && this.terminologyProvider == null) {
            throw new IllegalArgumentException(String.format("Library %s has terminology requirements and no terminology provider is registered.", this.getLibraryDescription(library.getIdentifier())));
        }
    }

    private String getLibraryDescription(VersionedIdentifier libraryIdentifier) {
        return libraryIdentifier.getId() + (libraryIdentifier.getVersion() != null ? "-" + libraryIdentifier.getVersion() : "");
    }

    private Set<String> getExpressionSet(Library library) {
        LinkedHashSet<String> expressionNames = new LinkedHashSet<String>();
        if (library.getStatements() != null && library.getStatements().getDef() != null) {
            for (ExpressionDef ed : library.getStatements().getDef()) {
                expressionNames.add(ed.getName());
            }
        }
        return expressionNames;
    }

    public static enum Options {
        EnableExpressionCaching;

    }
}

