/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.SameOrAfter;
import org.opencds.cqf.cql.engine.elm.execution.GreaterOrEqualEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;

public class SameOrAfterEvaluator
extends SameOrAfter {
    public static Boolean onOrAfter(Object left, Object right, String precision) {
        if (left instanceof Interval && right instanceof Interval) {
            if (((Interval)left).getStart() instanceof BaseTemporal) {
                return SameOrAfterEvaluator.sameOrAfter(((Interval)left).getStart(), ((Interval)right).getEnd(), precision);
            }
            return GreaterOrEqualEvaluator.greaterOrEqual(((Interval)left).getStart(), ((Interval)right).getEnd());
        }
        if (left instanceof Interval) {
            if (right instanceof BaseTemporal) {
                return SameOrAfterEvaluator.sameOrAfter(((Interval)left).getStart(), right, precision);
            }
            return GreaterOrEqualEvaluator.greaterOrEqual(((Interval)left).getStart(), right);
        }
        if (right instanceof Interval) {
            if (left instanceof BaseTemporal) {
                return SameOrAfterEvaluator.sameOrAfter(left, ((Interval)right).getEnd(), precision);
            }
            return GreaterOrEqualEvaluator.greaterOrEqual(left, ((Interval)right).getEnd());
        }
        throw new InvalidOperatorArgument("OnOrAfter(Date, Date), OnOrAfter(DateTime, DateTime), OnOrAfter(Time, Time), OnOrAfter(Interval<T>, Interval<T>), OnOrAfter(T, Interval<T>) or OnOrAfter(Interval<T>, T)", String.format("OnOrAfter(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    public static Boolean sameOrAfter(Object left, Object right, String precision) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval || right instanceof Interval) {
            return SameOrAfterEvaluator.onOrAfter(left, right, precision);
        }
        if (precision == null) {
            precision = BaseTemporal.getHighestPrecision((BaseTemporal)left, (BaseTemporal)right);
        }
        if (left instanceof BaseTemporal && right instanceof BaseTemporal) {
            Integer result = ((BaseTemporal)left).compareToPrecision((BaseTemporal)right, Precision.fromString(precision));
            return result == null ? null : Boolean.valueOf(result == 0 || result > 0);
        }
        throw new InvalidOperatorArgument("SameOrAfter(Date, Date), SameOrAfter(DateTime, DateTime), SameOrAfter(Time, Time), SameOrAfter(Interval<T>, Interval<T>), SameOrAfter(T, Interval<T>) or SameOrAfter(Interval<T>, T)", String.format("SameOrAfter(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        String precision = this.getPrecision() == null ? null : this.getPrecision().value();
        return SameOrAfterEvaluator.sameOrAfter(left, right, precision);
    }
}

