/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.Precision;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Time;

public class PrecisionEvaluator
extends Precision {
    public static Integer precision(Object argument) {
        if (argument == null) {
            return null;
        }
        if (argument instanceof BigDecimal) {
            String string = ((BigDecimal)argument).toPlainString();
            int index = string.indexOf(".");
            return index < 0 ? 0 : string.length() - index - 1;
        }
        if (argument instanceof Date) {
            return argument.toString().replaceAll("-", "").length();
        }
        if (argument instanceof DateTime) {
            return argument.toString().replaceAll("[T.:-]", "").length();
        }
        if (argument instanceof Time) {
            return argument.toString().replaceAll("[T.:]", "").length();
        }
        throw new InvalidOperatorArgument("Precision(Decimal), Precision(Date), Precision(DateTime) or Precision(Time)", String.format("Precision(%s)", argument.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object argument = this.getOperand().evaluate(context);
        return PrecisionEvaluator.precision(argument);
    }
}

