/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.MeetsBefore;
import org.opencds.cqf.cql.engine.elm.execution.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.InEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.MeetsEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class MeetsBeforeEvaluator
extends MeetsBefore {
    public static Boolean meetsBefore(Object left, Object right, String precision) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval && right instanceof Interval) {
            Boolean isLeftStartGreater = GreaterEvaluator.greater(((Interval)left).getStart(), ((Interval)right).getEnd());
            if (isLeftStartGreater != null && isLeftStartGreater.booleanValue()) {
                return false;
            }
            Object leftEnd = ((Interval)left).getEnd();
            Object rightStart = ((Interval)right).getStart();
            Boolean isIn = InEvaluator.in(leftEnd, right, precision);
            if (isIn != null && isIn.booleanValue()) {
                return false;
            }
            isIn = InEvaluator.in(((Interval)left).getStart(), right, precision);
            if (isIn != null && isIn.booleanValue()) {
                return false;
            }
            isIn = InEvaluator.in(leftEnd, right, precision);
            if (isIn != null && isIn.booleanValue()) {
                return false;
            }
            return MeetsEvaluator.meetsOperation(leftEnd, rightStart, precision);
        }
        throw new InvalidOperatorArgument("MeetsBefore(Interval<T>, Interval<T>)", String.format("MeetsBefore(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        String precision = this.getPrecision() == null ? null : this.getPrecision().value();
        return MeetsBeforeEvaluator.meetsBefore(left, right, precision);
    }
}

