/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import org.cqframework.cql.elm.execution.Median;
import org.opencds.cqf.cql.engine.elm.execution.AddEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.DivideEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.TruncatedDivideEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.CqlList;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class MedianEvaluator
extends Median {
    public static Object median(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Iterable) {
            Iterable element = (Iterable)source;
            Iterator itr = element.iterator();
            if (!itr.hasNext()) {
                return null;
            }
            ArrayList<Object> values = new ArrayList<Object>();
            while (itr.hasNext()) {
                Object value = itr.next();
                if (value == null) continue;
                values.add(value);
            }
            if (values.isEmpty()) {
                return null;
            }
            values.sort(new CqlList().valueSort);
            if (values.size() % 2 != 0) {
                return values.get(values.size() / 2);
            }
            if (values.get(0) instanceof Integer) {
                return TruncatedDivideEvaluator.div(AddEvaluator.add(values.get(values.size() / 2), values.get(values.size() / 2 - 1)), 2);
            }
            if (values.get(0) instanceof BigDecimal || values.get(0) instanceof Quantity) {
                return DivideEvaluator.divide(AddEvaluator.add(values.get(values.size() / 2), values.get(values.size() / 2 - 1)), new BigDecimal("2.0"));
            }
        }
        throw new InvalidOperatorArgument("Median(List<Decimal>) or Median(List<Quantity>)", String.format("Median(%s)", source.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object source = this.getSource().evaluate(context);
        return MedianEvaluator.median(source);
    }
}

