/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.CodeSystemDef;
import org.cqframework.cql.elm.execution.CodeSystemRef;
import org.cqframework.cql.elm.execution.InValueSet;
import org.cqframework.cql.elm.execution.ValueSetDef;
import org.cqframework.cql.elm.execution.ValueSetRef;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Concept;
import org.opencds.cqf.cql.engine.terminology.CodeSystemInfo;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;

public class InValueSetEvaluator
extends InValueSet {
    public static Object inValueSet(Context context, Object code, Object valueset) {
        if (code == null) {
            return null;
        }
        ValueSetDef vsd = InValueSetEvaluator.resolveVSR(context, (ValueSetRef)valueset);
        ValueSetInfo vsi = new ValueSetInfo().withId(vsd.getId()).withVersion(vsd.getVersion());
        for (CodeSystemRef csr : vsd.getCodeSystem()) {
            CodeSystemDef csd = InValueSetEvaluator.resolveCSR(context, csr);
            CodeSystemInfo csi = new CodeSystemInfo().withId(csd.getId()).withVersion(csd.getVersion());
            vsi.getCodeSystems().add(csi);
        }
        TerminologyProvider provider = context.resolveTerminologyProvider();
        if (code instanceof String) {
            if (provider.in(new Code().withCode((String)code), vsi)) {
                return true;
            }
            return false;
        }
        if (code instanceof Code) {
            if (provider.in((Code)code, vsi)) {
                return true;
            }
            return false;
        }
        if (code instanceof Concept) {
            for (Code codes : ((Concept)code).getCodes()) {
                if (codes == null) {
                    return null;
                }
                if (!provider.in(codes, vsi)) continue;
                return true;
            }
            return false;
        }
        throw new InvalidOperatorArgument("In(String, ValueSetRef), In(Code, ValueSetRef) or In(Concept, ValueSetRef)", String.format("In(%s, %s)", code.getClass().getName(), valueset.getClass().getName()));
    }

    public static ValueSetDef resolveVSR(Context context, ValueSetRef valueset) {
        return context.resolveValueSetRef(valueset.getLibraryName(), valueset.getName());
    }

    public static CodeSystemDef resolveCSR(Context context, CodeSystemRef codesystem) {
        return context.resolveCodeSystemRef(codesystem.getLibraryName(), codesystem.getName());
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object code = this.getCode().evaluate(context);
        ValueSetRef valueset = this.getValueset();
        return InValueSetEvaluator.inValueSet(context, code, valueset);
    }
}

