/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workspace.impl;

import java.util.Date;
import org.opencastproject.workspace.api.Workspace;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceCleaner {
    private static final Logger logger = LoggerFactory.getLogger(WorkspaceCleaner.class);
    private static final String JOB_NAME = "mh-workspace-cleaner-job";
    private static final String JOB_GROUP = "mh-workspace-cleaner-job-group";
    private static final String TRIGGER_NAME = "mh-workspace-cleaner-trigger";
    private static final String TRIGGER_GROUP = "mh-workspace-cleaner-trigger-group";
    private static final String JOB_PARAM_PARENT = "parent";
    private final Scheduler quartz;
    private final Workspace workspace;
    private final int maxAge;
    private int schedulerPeriod;

    protected WorkspaceCleaner(Workspace workspace, int schedulerPeriod, int maxAge) {
        this.workspace = workspace;
        this.maxAge = maxAge;
        this.schedulerPeriod = schedulerPeriod;
        if (schedulerPeriod <= 0) {
            logger.debug("No scheduler initialized due to invalid scheduling period ({})", (Object)schedulerPeriod);
            this.quartz = null;
            return;
        }
        try {
            this.quartz = new StdSchedulerFactory().getScheduler();
            this.quartz.start();
            JobDetail job = new JobDetail(JOB_NAME, JOB_GROUP, Runner.class);
            job.setDurability(false);
            job.setVolatility(true);
            job.getJobDataMap().put((Object)JOB_PARAM_PARENT, (Object)this);
            this.quartz.addJob(job, true);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void schedule() {
        if (this.quartz == null || this.schedulerPeriod <= 0) {
            logger.debug("Cancel scheduling of workspace cleaner due to invalid scheduling period");
            return;
        }
        logger.debug("Scheduling workspace cleaner to run every {} seconds.", (Object)this.schedulerPeriod);
        try {
            Trigger trigger = TriggerUtils.makeSecondlyTrigger((int)this.schedulerPeriod);
            trigger.setStartTime(new Date());
            trigger.setName(TRIGGER_NAME);
            trigger.setGroup(TRIGGER_GROUP);
            trigger.setJobName(JOB_NAME);
            trigger.setJobGroup(JOB_GROUP);
            if (this.quartz.getTriggersOfJob(JOB_NAME, JOB_GROUP).length == 0) {
                this.quartz.scheduleJob(trigger);
            } else {
                this.quartz.rescheduleJob(TRIGGER_NAME, TRIGGER_GROUP, trigger);
            }
        }
        catch (Exception e) {
            logger.error("Error scheduling Quartz job", (Throwable)e);
        }
    }

    public void shutdown() {
        try {
            this.quartz.shutdown();
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    public static class Runner
    implements Job {
        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            logger.debug("Start workspace cleaner");
            try {
                this.execute((WorkspaceCleaner)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)WorkspaceCleaner.JOB_PARAM_PARENT));
            }
            catch (Exception e) {
                throw new JobExecutionException("An error occurred while cleaning workspace", (Throwable)e);
            }
            logger.debug("Finished workspace cleaner");
        }

        private void execute(WorkspaceCleaner workspaceCleaner) {
            workspaceCleaner.getWorkspace().cleanup(workspaceCleaner.getMaxAge());
        }
    }
}

