/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.commons.io.FilenameUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.rest.StaticResource;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ResumableWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;

public class ResumableWorkflowOperationHandlerBase
extends AbstractWorkflowOperationHandler
implements ResumableWorkflowOperationHandler {
    protected ComponentContext componentContext = null;
    protected ServiceRegistration staticResourceRegistration = null;
    protected StaticResource staticResource = null;
    protected String holdActionTitle = null;
    private static final String DEFAULT_TITLE = "Action";

    public void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        super.activate(componentContext);
    }

    public void deactivate() {
        if (this.staticResourceRegistration != null) {
            this.staticResourceRegistration.unregister();
        }
    }

    public String getHoldStateUserInterfaceURL(WorkflowInstance workflowInstance) throws WorkflowOperationException {
        if (this.staticResource == null) {
            return null;
        }
        return this.staticResource.getDefaultUrl();
    }

    protected void setHoldActionTitle(String title) {
        this.holdActionTitle = title;
    }

    public String getHoldActionTitle() {
        if (this.holdActionTitle == null) {
            return DEFAULT_TITLE;
        }
        return this.holdActionTitle;
    }

    protected String registerHoldStateUserInterface(String resourcePath) {
        String alias = "/workflow/hold/" + ((Object)((Object)this)).getClass().getName().toLowerCase();
        if (resourcePath == null) {
            throw new IllegalArgumentException("Classpath must not be null");
        }
        String path = FilenameUtils.getPathNoEndSeparator((String)resourcePath);
        String welcomeFile = FilenameUtils.getName((String)resourcePath);
        this.staticResource = new StaticResource(((Object)((Object)this)).getClass().getClassLoader(), path, alias, welcomeFile);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("httpContext.id", "opencast.httpcontext");
        ((Dictionary)props).put("alias", alias);
        this.staticResourceRegistration = this.componentContext.getBundleContext().registerService(Servlet.class.getName(), (Object)this.staticResource, props);
        return this.staticResource.getDefaultUrl();
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        return this.createResult(WorkflowOperationResult.Action.PAUSE);
    }

    public WorkflowOperationResult resume(WorkflowInstance workflowInstance, JobContext context, Map<String, String> properties) throws WorkflowOperationException {
        return this.createResult(WorkflowOperationResult.Action.CONTINUE);
    }

    public boolean isAlwaysPause() {
        return false;
    }
}

