/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(TagWorkflowOperationHandler.class);
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    public static final String SOURCE_FLAVORS_PROPERTY = "source-flavors";
    public static final String SOURCE_TAGS_PROPERTY = "source-tags";
    public static final String TARGET_FLAVOR_PROPERTY = "target-flavor";
    public static final String TARGET_TAGS_PROPERTY = "target-tags";
    public static final String COPY_PROPERTY = "copy";

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        String configuredSourceFlavors = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(SOURCE_FLAVORS_PROPERTY));
        String configuredSourceTags = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(SOURCE_TAGS_PROPERTY));
        String configuredTargetFlavor = StringUtils.trimToNull((String)currentOperation.getConfiguration(TARGET_FLAVOR_PROPERTY));
        String configuredTargetTags = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(TARGET_TAGS_PROPERTY));
        boolean copy = BooleanUtils.toBoolean((String)currentOperation.getConfiguration(COPY_PROPERTY));
        if (copy) {
            logger.info("Retagging mediapackage elements as a copy");
        } else {
            logger.info("Retagging mediapackage elements");
        }
        String[] sourceTags = StringUtils.split((String)configuredSourceTags, (String)",");
        String[] targetTags = StringUtils.split((String)configuredTargetTags, (String)",");
        String[] sourceFlavors = StringUtils.split((String)configuredSourceFlavors, (String)",");
        SimpleElementSelector elementSelector = new SimpleElementSelector();
        for (String string : sourceFlavors) {
            elementSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)string));
        }
        ArrayList<String> removeTags = new ArrayList<String>();
        ArrayList<String> addTags = new ArrayList<String>();
        ArrayList<String> overrideTags = new ArrayList<String>();
        for (String tag : targetTags) {
            if (tag.startsWith(MINUS)) {
                removeTags.add(tag);
                continue;
            }
            if (tag.startsWith(PLUS)) {
                addTags.add(tag);
                continue;
            }
            overrideTags.add(tag);
        }
        for (String tag : sourceTags) {
            elementSelector.addTag(tag);
        }
        Collection collection = elementSelector.select(mediaPackage, false);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MediaPackageElement e;
            MediaPackageElement element = e = (MediaPackageElement)iterator.next();
            if (copy) {
                element = (MediaPackageElement)e.clone();
                element.setIdentifier(null);
                element.setURI(e.getURI());
            }
            if (configuredTargetFlavor != null) {
                element.setFlavor(MediaPackageElementFlavor.parseFlavor((String)configuredTargetFlavor));
            }
            if (overrideTags.size() > 0) {
                element.clearTags();
                for (String tag : overrideTags) {
                    element.addTag(tag);
                }
            } else {
                for (String tag : removeTags) {
                    element.removeTag(tag.substring(MINUS.length()));
                }
                for (String tag : addTags) {
                    element.addTag(tag.substring(PLUS.length()));
                }
            }
            if (!copy) continue;
            mediaPackage.addDerived(element, e);
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }
}

