/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.fns.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.handler.workflow.ImportWorkflowPropertiesWOH;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportWorkflowPropertiesWOH
extends AbstractWorkflowOperationHandler {
    public static final String KEYS_PROPERTY = "keys";
    public static final String TARGET_FLAVOR_PROPERTY = "target-flavor";
    public static final String TARGET_TAGS_PROPERTY = "target-tags";
    public static final String DEFAULT_TARGET_FLAVOR = MediaPackageElements.PROCESSING_PROPERTIES.toString();
    public static final String EXPORTED_PROPERTIES_FILENAME = "processing-properties.xml";
    public static final SortedMap<String, String> CONFIG_OPTIONS = new TreeMap<String, String>();
    private static final Logger logger;
    private Workspace workspace;

    void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        Attachment attachment;
        logger.info("Start exporting workflow properties for workflow {}", (Object)workflowInstance);
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        Set keys = Stream.$((Iterable)this.getOptConfig(workflowInstance, KEYS_PROPERTY)).bind(Strings.splitCsv).toSet();
        String targetFlavorString = (String)this.getOptConfig(workflowInstance, TARGET_FLAVOR_PROPERTY).getOr((Object)DEFAULT_TARGET_FLAVOR);
        Stream targetTags = Stream.$((Iterable)this.getOptConfig(workflowInstance, TARGET_TAGS_PROPERTY)).bind(Strings.splitCsv);
        MediaPackageElementFlavor targetFlavor = MediaPackageElementFlavor.parseFlavor((String)targetFlavorString);
        Properties workflowProps = new Properties();
        Opt<Attachment> existingPropsElem = ImportWorkflowPropertiesWOH.loadPropertiesElementFromMediaPackage(targetFlavor, workflowInstance);
        if (existingPropsElem.isSome()) {
            workflowProps = ImportWorkflowPropertiesWOH.loadPropertiesFromXml(this.workspace, ((Attachment)existingPropsElem.get()).getURI());
            for (String key : keys) {
                workflowProps.remove(key);
            }
        }
        for (String key : workflowInstance.getConfigurationKeys()) {
            if (!keys.isEmpty() && !keys.contains(key)) continue;
            workflowProps.put(key, workflowInstance.getConfiguration(key));
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            workflowProps.storeToXML((OutputStream)out, null, "UTF-8");
            String elementId = UUID.randomUUID().toString();
            URI uri = this.workspace.put(mediaPackage.getIdentifier().compact(), elementId, EXPORTED_PROPERTIES_FILENAME, (InputStream)new ByteArrayInputStream(out.toByteArray()));
            MediaPackageElementBuilder builder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
            attachment = (Attachment)builder.elementFromURI(uri, Attachment.TYPE, targetFlavor);
            attachment.setMimeType(MimeTypes.XML);
        }
        catch (IOException e) {
            logger.error("Unable to store workflow properties as Attachment with flavor '{}': {}", (Object)targetFlavorString, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new WorkflowOperationException("Unable to store workflow properties as Attachment", (Throwable)e);
        }
        for (String tag : targetTags) {
            logger.trace("Tagging with '{}'", (Object)tag);
            attachment.addTag(tag);
        }
        if (existingPropsElem.isSome()) {
            mediaPackage.remove((Attachment)existingPropsElem.get());
        }
        mediaPackage.add(attachment);
        logger.info("Added properties from {} as Attachment with flavor {}", (Object)workflowInstance, (Object)targetFlavorString);
        logger.debug("Workflow properties: {}", (Object)this.propertiesAsString(workflowProps));
        return this.createResult(mediaPackage, null, WorkflowOperationResult.Action.CONTINUE, 0L);
    }

    private String propertiesAsString(Properties properties) {
        StringWriter writer = new StringWriter();
        properties.list(new PrintWriter(writer));
        return writer.getBuffer().toString();
    }

    static {
        CONFIG_OPTIONS.put(KEYS_PROPERTY, "The workflow property keys that need to be persisted. If the option is not specified, all defined properties should be persisted.");
        CONFIG_OPTIONS.put(TARGET_FLAVOR_PROPERTY, "The flavor to apply to the exported workflow properties");
        CONFIG_OPTIONS.put(TARGET_TAGS_PROPERTY, "The tags to apply to the exported workflow properties");
        logger = LoggerFactory.getLogger(ExportWorkflowPropertiesWOH.class);
    }
}

