/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.handler.workflow.ResumableWorkflowOperationHandlerBase;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureByDublinCoreTermWOH
extends ResumableWorkflowOperationHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(ConfigureByDublinCoreTermWOH.class);
    private static final SortedMap<String, String> CONFIG_OPTIONS = new TreeMap<String, String>();
    public static final String DCCATALOG_PROPERTY = "dccatalog";
    public static final String DCTERM_PROPERTY = "dcterm";
    public static final String DEFAULT_VALUE_PROPERTY = "default-value";
    public static final String MATCH_VALUE_PROPERTY = "match-value";
    public static final String COPY_PROPERTY = "copy";
    private Workspace workspace = null;

    public SortedMap<String, String> getConfigurationOptions() {
        return CONFIG_OPTIONS;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        String configuredCatalog = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(DCCATALOG_PROPERTY));
        String configuredDCTerm = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(DCTERM_PROPERTY));
        String configuredDefaultValue = StringUtils.trimToNull((String)currentOperation.getConfiguration(DEFAULT_VALUE_PROPERTY));
        String configuredMatchValue = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(MATCH_VALUE_PROPERTY));
        Catalog[] catalogs = mediaPackage.getCatalogs(new MediaPackageElementFlavor("dublincore", StringUtils.lowerCase((String)configuredCatalog)));
        if (catalogs != null && catalogs.length > 0) {
            Boolean foundValue = false;
            EName dcterm = new EName("http://purl.org/dc/terms/", configuredDCTerm);
            for (Catalog catalog : catalogs) {
                DublinCoreCatalog dc = DublinCoreUtil.loadDublinCore((Workspace)this.workspace, (MediaPackageElement)catalog);
                List values = dc.get(dcterm);
                if (values.isEmpty()) {
                    if (configuredDefaultValue == null) continue;
                    foundValue = configuredDefaultValue.equals(configuredMatchValue);
                    continue;
                }
                foundValue = values.contains(DublinCoreValue.mk((String)configuredMatchValue));
            }
            if (foundValue.booleanValue()) {
                HashMap<String, String> properties = new HashMap<String, String>();
                for (String key : currentOperation.getConfigurationKeys()) {
                    if (DCCATALOG_PROPERTY.equals(key) || DCTERM_PROPERTY.equals(key) || DEFAULT_VALUE_PROPERTY.equals(key) || MATCH_VALUE_PROPERTY.equals(key)) continue;
                    String value = currentOperation.getConfiguration(key);
                    properties.put(key, value);
                    logger.info("Configuration key '{}' of workflow {} is set to value '{}'", new Object[]{key, workflowInstance.getId(), value});
                }
                return this.createResult(mediaPackage, properties, WorkflowOperationResult.Action.CONTINUE, 0L);
            }
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    static {
        CONFIG_OPTIONS.put(DCCATALOG_PROPERTY, "The flavor of the catalog to examine, will throw error if not present");
        CONFIG_OPTIONS.put(DCTERM_PROPERTY, "The Dublin Core term/element to examine");
        CONFIG_OPTIONS.put(DEFAULT_VALUE_PROPERTY, "The Dublin Core term/element's value if not found, if this is not given then match will fail");
        CONFIG_OPTIONS.put(MATCH_VALUE_PROPERTY, "The match the Dublin Core term/element against this value, if true then apply target-tags");
    }
}

