/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.api.WorkflowParsingException;
import org.opencastproject.workflow.api.WorkflowService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Start Workflow Workflow Operation Handler", "workflow.operation=start-workflow"})
public class StartWorkflowWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(StartWorkflowWorkflowOperationHandler.class);
    @Deprecated
    public static final String MEDIA_PACKAGE_ID = "media-package";
    public static final String MEDIA_PACKAGE_IDS = "media-packages";
    public static final String WORKFLOW_DEFINITION = "workflow-definition";
    private AssetManager assetManager;
    private WorkflowService workflowService;

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Reference
    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        WorkflowDefinition workflowDefinition;
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        String mediaPackageIDs = StringUtils.trimToEmpty((String)operation.getConfiguration(MEDIA_PACKAGE_IDS));
        if ("".equals(mediaPackageIDs)) {
            mediaPackageIDs = StringUtils.trimToEmpty((String)operation.getConfiguration(MEDIA_PACKAGE_ID));
        }
        String configuredMediaPackageIDs = mediaPackageIDs;
        String configuredWorkflowDefinition = StringUtils.trimToEmpty((String)operation.getConfiguration(WORKFLOW_DEFINITION));
        Boolean failOnError = operation.isFailOnError();
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String key : operation.getConfigurationKeys()) {
            if (MEDIA_PACKAGE_ID.equals(key) || MEDIA_PACKAGE_IDS.equals(key) || WORKFLOW_DEFINITION.equals(key)) continue;
            properties.put(key, operation.getConfiguration(key));
        }
        try {
            workflowDefinition = this.workflowService.getWorkflowDefinitionById(configuredWorkflowDefinition);
        }
        catch (NotFoundException e) {
            throw new WorkflowOperationException(String.format("Workflow Definition '%s' not found", configuredWorkflowDefinition));
        }
        catch (WorkflowDatabaseException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        Object errors = "";
        String delim = "";
        for (String mpId : this.asList(configuredMediaPackageIDs)) {
            Optional mpOpt = this.assetManager.getMediaPackage(mpId);
            if (mpOpt.isEmpty()) {
                String errstr = String.format("Media package %s not found", mpId);
                if (failOnError.booleanValue()) {
                    throw new WorkflowOperationException(errstr);
                }
                logger.error(errstr);
                errors = (String)errors + delim + errstr;
                delim = "\n";
                continue;
            }
            MediaPackage mp = (MediaPackage)mpOpt.get();
            try {
                logger.info("Starting '{}' workflow for media package '{}'", (Object)configuredWorkflowDefinition, (Object)mpId);
                this.workflowService.start(workflowDefinition, mp, properties);
            }
            catch (UnauthorizedException | WorkflowDatabaseException | WorkflowParsingException e) {
                if (failOnError.booleanValue()) {
                    throw new WorkflowOperationException(e);
                }
                logger.error(e.getMessage(), e);
                errors = (String)errors + delim + e.getMessage();
            }
        }
        if (!((String)errors).isEmpty()) {
            throw new WorkflowOperationException((String)errors);
        }
        return this.createResult(WorkflowOperationResult.Action.CONTINUE);
    }
}

