/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.selector.CatalogSelector;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.metadata.dublincore.SeriesCatalogUIAdapter;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AclScope;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.Checksum;
import org.opencastproject.util.ChecksumType;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.XmlNamespaceBinding;
import org.opencastproject.util.XmlNamespaceContext;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Apply Series to Recording Workflow Operation Handler", "workflow.operation=series"})
public class SeriesWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(SeriesWorkflowOperationHandler.class);
    public static final String SERIES_PROPERTY = "series";
    public static final String ATTACH_PROPERTY = "attach";
    public static final String APPLY_ACL_PROPERTY = "apply-acl";
    public static final String COPY_METADATA_PROPERTY = "copy-metadata";
    public static final String DEFAULT_NS_PROPERTY = "default-namespace";
    private AuthorizationService authorizationService;
    private SeriesService seriesService;
    private Workspace workspace;
    private SecurityService securityService;
    private final List<SeriesCatalogUIAdapter> seriesCatalogUIAdapters = new ArrayList<SeriesCatalogUIAdapter>();

    @Reference
    protected void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Reference
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeCatalogUIAdapter")
    public void addCatalogUIAdapter(SeriesCatalogUIAdapter catalogUIAdapter) {
        this.seriesCatalogUIAdapters.add(catalogUIAdapter);
    }

    public void removeCatalogUIAdapter(SeriesCatalogUIAdapter catalogUIAdapter) {
        this.seriesCatalogUIAdapters.remove(catalogUIAdapter);
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        DublinCoreCatalog series;
        String seriesId;
        logger.debug("Running series workflow operation");
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        Optional<String> optSeries = Optional.ofNullable((String)this.getOptConfig(workflowInstance.getCurrentOperation(), SERIES_PROPERTY).orNull());
        Optional<String> optAttachFlavors = Optional.ofNullable((String)this.getOptConfig(workflowInstance.getCurrentOperation(), ATTACH_PROPERTY).orNull());
        Boolean applyAcl = Optional.ofNullable((String)this.getOptConfig(workflowInstance.getCurrentOperation(), APPLY_ACL_PROPERTY).orNull()).map(value -> BooleanUtils.toBoolean((String)value)).orElse(false);
        Optional<String> optCopyMetadata = Optional.ofNullable((String)this.getOptConfig(workflowInstance.getCurrentOperation(), COPY_METADATA_PROPERTY).orNull());
        String defaultNamespace = Optional.ofNullable((String)this.getOptConfig(workflowInstance.getCurrentOperation(), DEFAULT_NS_PROPERTY).orNull()).orElse("http://purl.org/dc/terms/");
        logger.debug("Using default namespace: '{}'", (Object)defaultNamespace);
        if (optSeries.isPresent() && !optSeries.get().equals(mediaPackage.getSeries())) {
            logger.info("Changing series id from '{}' to '{}'", (Object)StringUtils.trimToEmpty((String)mediaPackage.getSeries()), (Object)optSeries.get());
            mediaPackage.setSeries(optSeries.get());
        }
        if ((seriesId = mediaPackage.getSeries()) == null) {
            logger.info("No series set, skip operation");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        try {
            series = this.seriesService.getSeries(seriesId);
        }
        catch (NotFoundException e) {
            logger.info("No series with the identifier '{}' found, skip operation", (Object)seriesId);
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        catch (UnauthorizedException e) {
            logger.warn("Not authorized to get series with identifier '{}' found, skip operation", (Object)seriesId);
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        catch (SeriesException e) {
            logger.error("Unable to get series with identifier '{}', skip operation:", (Object)seriesId, (Object)e);
            throw new WorkflowOperationException((Throwable)e);
        }
        mediaPackage.setSeriesTitle(series.getFirst(DublinCore.PROPERTY_TITLE));
        HashSet<EName> extraMetadata = new HashSet<EName>();
        if (optCopyMetadata.isPresent()) {
            for (String string : optCopyMetadata.get().split(",+\\s*")) {
                try {
                    if (string.isEmpty()) continue;
                    extraMetadata.add(EName.fromString((String)string, (String)defaultNamespace));
                }
                catch (IllegalArgumentException iae) {
                    logger.warn("Ignoring incorrect dublincore metadata property: '{}'", (Object)string);
                }
            }
        }
        for (Catalog catalog : mediaPackage.getCatalogs(MediaPackageElements.EPISODE)) {
            DublinCoreCatalog episodeDublinCore = DublinCoreUtil.loadDublinCore((Workspace)this.workspace, (MediaPackageElement)catalog);
            episodeDublinCore.addBindings(XmlNamespaceContext.mk((XmlNamespaceBinding[])new XmlNamespaceBinding[]{XmlNamespaceBinding.mk((String)"dcterms", (String)"http://purl.org/dc/terms/")}));
            episodeDublinCore.addBindings(XmlNamespaceContext.mk((XmlNamespaceBinding[])new XmlNamespaceBinding[]{XmlNamespaceBinding.mk((String)"dc", (String)"http://purl.org/dc/elements/1.1/")}));
            episodeDublinCore.addBindings(XmlNamespaceContext.mk((XmlNamespaceBinding[])new XmlNamespaceBinding[]{XmlNamespaceBinding.mk((String)"oc", (String)"http://www.opencastproject.org/matterhorn/")}));
            episodeDublinCore.set(DublinCore.PROPERTY_IS_PART_OF, seriesId);
            for (EName property : extraMetadata) {
                if (episodeDublinCore.hasValue(property) || !series.hasValue(property)) continue;
                episodeDublinCore.set(property, series.get(property));
            }
            try (InputStream in = IOUtils.toInputStream((String)episodeDublinCore.toXmlString(), (String)"UTF-8");){
                String filename = FilenameUtils.getName((String)catalog.getURI().toString());
                URI uri = this.workspace.put(mediaPackage.getIdentifier().toString(), catalog.getIdentifier(), filename, in);
                catalog.setURI(uri);
                catalog.setChecksum(null);
            }
            catch (Exception e) {
                logger.error("Unable to update episode catalog isPartOf field", (Throwable)e);
                throw new WorkflowOperationException((Throwable)e);
            }
        }
        if (optAttachFlavors.isPresent()) {
            CatalogSelector catalogSelector = new CatalogSelector();
            String[] seriesFlavors = StringUtils.split((String)optAttachFlavors.get(), (String)",");
            for (String flavor : seriesFlavors) {
                if ("*".equals(flavor)) {
                    catalogSelector.addFlavor("*/*");
                    continue;
                }
                catalogSelector.addFlavor(flavor);
            }
            for (Catalog catalog : catalogSelector.select(mediaPackage, false)) {
                if (!MediaPackageElements.SERIES.equals((Object)catalog.getFlavor()) && !SERIES_PROPERTY.equals(catalog.getFlavor().getSubtype())) continue;
                mediaPackage.remove(catalog);
            }
            List<SeriesCatalogUIAdapter> adapters = this.getSeriesCatalogUIAdapters();
            for (String flavorString : seriesFlavors) {
                MediaPackageElementFlavor flavor = "*".equals(flavorString) ? MediaPackageElementFlavor.parseFlavor((String)"*/*") : MediaPackageElementFlavor.parseFlavor((String)flavorString);
                for (SeriesCatalogUIAdapter a : adapters) {
                    MediaPackageElementFlavor adapterFlavor = MediaPackageElementFlavor.parseFlavor((String)a.getFlavor().toString());
                    if (!flavor.matches(adapterFlavor)) continue;
                    if (MediaPackageElements.SERIES.eq(a.getFlavor().toString())) {
                        this.addDublinCoreCatalog(series, MediaPackageElements.SERIES, mediaPackage);
                        continue;
                    }
                    try {
                        Optional seriesElementData = this.seriesService.getSeriesElementData(seriesId, adapterFlavor.getType());
                        if (seriesElementData.isPresent()) {
                            DublinCoreCatalog catalog = DublinCores.read((InputStream)new ByteArrayInputStream((byte[])seriesElementData.get()));
                            this.addDublinCoreCatalog(catalog, adapterFlavor, mediaPackage);
                            continue;
                        }
                        logger.warn("No extended series catalog found for flavor '{}' and series '{}', skip adding catalog", (Object)adapterFlavor.getType(), (Object)seriesId);
                    }
                    catch (SeriesException e) {
                        logger.error("Unable to load extended series metadata for flavor {}", (Object)adapterFlavor.getType());
                        throw new WorkflowOperationException((Throwable)e);
                    }
                }
            }
        }
        if (applyAcl.booleanValue()) {
            try {
                AccessControlList accessControlList = this.seriesService.getSeriesAccessControl(seriesId);
                if (accessControlList != null) {
                    this.authorizationService.setAcl(mediaPackage, AclScope.Series, accessControlList);
                }
            }
            catch (Exception exception) {
                logger.error("Unable to update series ACL", (Throwable)exception);
                throw new WorkflowOperationException((Throwable)exception);
            }
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    private List<SeriesCatalogUIAdapter> getSeriesCatalogUIAdapters() {
        String organization = this.securityService.getOrganization().getId();
        ArrayList<SeriesCatalogUIAdapter> filteredAdapters = new ArrayList<SeriesCatalogUIAdapter>();
        for (SeriesCatalogUIAdapter adapter : this.seriesCatalogUIAdapters) {
            if (!adapter.handlesOrganization(organization)) continue;
            filteredAdapters.add(adapter);
        }
        return filteredAdapters;
    }

    private MediaPackage addDublinCoreCatalog(DublinCoreCatalog catalog, MediaPackageElementFlavor flavor, MediaPackage mediaPackage) throws WorkflowOperationException {
        MediaPackage mediaPackage2;
        block8: {
            InputStream in = IOUtils.toInputStream((String)catalog.toXmlString(), (String)"UTF-8");
            try {
                String elementId = UUID.randomUUID().toString();
                URI catalogUrl = this.workspace.put(mediaPackage.getIdentifier().toString(), elementId, "dublincore.xml", in);
                logger.info("Adding catalog with flavor {} to mediapackage {}", (Object)flavor, (Object)mediaPackage);
                MediaPackageElement mpe = mediaPackage.add(catalogUrl, MediaPackageElement.Type.Catalog, flavor);
                mpe.setIdentifier(elementId);
                mpe.setChecksum(Checksum.create((ChecksumType)ChecksumType.DEFAULT_TYPE, (File)this.workspace.get(catalogUrl)));
                mediaPackage2 = mediaPackage;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NotFoundException e) {
                    throw new WorkflowOperationException(e);
                }
            }
            in.close();
        }
        return mediaPackage2;
    }
}

