/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.util.HashMap;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.api.WorkflowService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Include Operation Handler", "workflow.operation=include"})
public final class IncludeWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(IncludeWorkflowOperationHandler.class);
    public static final String WORKFLOW_CFG = "workflow-id";
    private WorkflowService workflowService = null;

    @Activate
    public void activate(ComponentContext componentContext) {
        super.activate(componentContext);
    }

    public WorkflowOperationResult start(WorkflowInstance wi, JobContext context) throws WorkflowOperationException {
        String workflowDefinitionId = this.getConfig(wi, WORKFLOW_CFG);
        this.insertWorkflow(wi, workflowDefinitionId);
        HashMap<String, String> props = new HashMap<String, String>();
        for (String key : wi.getConfigurationKeys()) {
            props.put(key, wi.getConfiguration(key));
        }
        return this.createResult(wi.getMediaPackage(), props, WorkflowOperationResult.Action.CONTINUE, 0L);
    }

    public void insertWorkflow(WorkflowInstance wi, String workflowDefinitionId) throws WorkflowOperationException {
        try {
            WorkflowDefinition definition = this.workflowService.getWorkflowDefinitionById(workflowDefinitionId);
            if (definition != null) {
                logger.info("Insert workflow {} into the current workflow instance", (Object)workflowDefinitionId);
                wi.insert(definition, wi.getCurrentOperation());
            } else {
                logger.warn("Workflow definition {} cannot be found", (Object)workflowDefinitionId);
            }
        }
        catch (Exception e) {
            throw new WorkflowOperationException("Error inserting workflow " + workflowDefinitionId, (Throwable)e);
        }
    }

    @Reference
    public void setWorkflowService(WorkflowService service) {
        this.workflowService = service;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

