/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.selector.AttachmentSelector;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Import Workflow Properties Workflow Operation Handler", "workflow.operation=import-wf-properties"})
public class ImportWorkflowPropertiesWOH
extends AbstractWorkflowOperationHandler {
    public static final String SOURCE_FLAVOR_PROPERTY = "source-flavor";
    public static final String KEYS_PROPERTY = "keys";
    private static final Logger logger = LoggerFactory.getLogger(ImportWorkflowPropertiesWOH.class);
    private Workspace workspace;

    @Reference
    void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance wi, JobContext context) throws WorkflowOperationException {
        logger.info("Start importing workflow properties for workflow {}", (Object)wi);
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(wi, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.one, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none);
        MediaPackageElementFlavor sourceFlavor = tagsAndFlavors.getSingleSrcFlavor();
        MediaPackage mp = wi.getMediaPackage();
        AttachmentSelector attachmentSelector = new AttachmentSelector();
        attachmentSelector.addFlavor(sourceFlavor);
        Collection attachments = attachmentSelector.select(mp, false);
        if (attachments.size() == 1) {
            Attachment propertiesElem = (Attachment)attachments.iterator().next();
            Properties properties = ImportWorkflowPropertiesWOH.loadPropertiesFromXml(this.workspace, propertiesElem.getURI());
            Set<String> keys = Optional.ofNullable((String)this.getOptConfig(wi, KEYS_PROPERTY).orNull()).map(s -> Arrays.stream(s.split("\\s*,\\s*")).collect(Collectors.toSet())).orElse(Collections.emptySet());
            return this.createResult(mp, this.convertToWorkflowProperties(properties, keys), WorkflowOperationResult.Action.CONTINUE, 0L);
        }
        logger.info("No attachment with workflow properties found, skipping...");
        return this.createResult(mp, WorkflowOperationResult.Action.SKIP);
    }

    static Properties loadPropertiesFromXml(Workspace workspace, URI uri) throws WorkflowOperationException {
        Properties properties = new Properties();
        try {
            File propertiesFile = workspace.get(uri);
            try (FileInputStream is = new FileInputStream(propertiesFile);){
                properties.loadFromXML(is);
                logger.debug("Properties loaded from {}", (Object)propertiesFile);
            }
        }
        catch (NotFoundException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        catch (IOException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        return properties;
    }

    private Map<String, String> convertToWorkflowProperties(Properties properties, Set<String> keys) {
        HashMap<String, String> workflowProperties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!keys.isEmpty() && !keys.contains(entry.getKey())) continue;
            workflowProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        return workflowProperties;
    }
}

