/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.handler.workflow.ResumableWorkflowOperationHandlerBase;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Tag by Dublin Core Term Workflow Handler", "workflow.operation=tag-by-dcterm"})
public class TagByDublinCoreTermWOH
extends ResumableWorkflowOperationHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(TagByDublinCoreTermWOH.class);
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    public static final String SOURCE_FLAVORS_PROPERTY = "source-flavors";
    public static final String TARGET_TAGS_PROPERTY = "target-tags";
    public static final String DCCATALOG_PROPERTY = "dccatalog";
    public static final String DCTERM_PROPERTY = "dcterm";
    public static final String DEFAULT_VALUE_PROPERTY = "default-value";
    public static final String MATCH_VALUE_PROPERTY = "match-value";
    public static final String COPY_PROPERTY = "copy";
    private Workspace workspace = null;

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many);
        List configuredSourceFlavors = tagsAndFlavors.getSrcFlavors();
        List configuredSourceTags = tagsAndFlavors.getSrcTags();
        String configuredCatalog = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(DCCATALOG_PROPERTY));
        String configuredDCTerm = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(DCTERM_PROPERTY));
        String configuredDefaultValue = StringUtils.trimToNull((String)currentOperation.getConfiguration(DEFAULT_VALUE_PROPERTY));
        String configuredMatchValue = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(MATCH_VALUE_PROPERTY));
        List configuredTargetFlavor = tagsAndFlavors.getTargetFlavors();
        List configuredTargetTags = tagsAndFlavors.getTargetTags();
        boolean copy = BooleanUtils.toBoolean((String)currentOperation.getConfiguration(COPY_PROPERTY));
        SimpleElementSelector elementSelector = new SimpleElementSelector();
        for (MediaPackageElementFlavor flavor : configuredSourceFlavors) {
            elementSelector.addFlavor(flavor);
        }
        for (String tag : configuredSourceTags) {
            elementSelector.addTag(tag);
        }
        ArrayList<String> removeTags = new ArrayList<String>();
        ArrayList<String> addTags = new ArrayList<String>();
        ArrayList<String> overrideTags = new ArrayList<String>();
        for (String tag : configuredTargetTags) {
            if (tag.startsWith(MINUS)) {
                removeTags.add(tag);
                continue;
            }
            if (tag.startsWith(PLUS)) {
                addTags.add(tag);
                continue;
            }
            overrideTags.add(tag);
        }
        Catalog[] catalogs = mediaPackage.getCatalogs(new MediaPackageElementFlavor("dublincore", StringUtils.lowerCase((String)configuredCatalog)));
        if (catalogs != null && catalogs.length > 0) {
            Boolean foundValue = false;
            EName dcterm = new EName("http://purl.org/dc/terms/", configuredDCTerm);
            for (Catalog catalog : catalogs) {
                DublinCoreCatalog dc = DublinCoreUtil.loadDublinCore((Workspace)this.workspace, (MediaPackageElement)catalog);
                List values = dc.get(dcterm);
                if (values.isEmpty()) {
                    if (configuredDefaultValue == null) continue;
                    foundValue = configuredDefaultValue.equals(configuredMatchValue);
                    continue;
                }
                foundValue = values.contains(DublinCoreValue.mk((String)configuredMatchValue));
            }
            if (foundValue.booleanValue()) {
                if (copy) {
                    logger.info("Retagging mediapackage elements as a copy");
                } else {
                    logger.info("Retagging mediapackage elements");
                }
                Collection elements = elementSelector.select(mediaPackage, false);
                Iterator iterator = elements.iterator();
                while (iterator.hasNext()) {
                    MediaPackageElement e;
                    MediaPackageElement element = e = (MediaPackageElement)iterator.next();
                    if (copy) {
                        element = (MediaPackageElement)e.clone();
                        element.setIdentifier(null);
                        element.setURI(e.getURI());
                    }
                    if (!configuredTargetFlavor.isEmpty()) {
                        element.setFlavor((MediaPackageElementFlavor)configuredTargetFlavor.get(0));
                    }
                    if (overrideTags.size() > 0) {
                        element.clearTags();
                        for (String tag : overrideTags) {
                            element.addTag(tag);
                        }
                    } else {
                        for (String tag : removeTags) {
                            element.removeTag(tag.substring(MINUS.length()));
                        }
                        for (String tag : addTags) {
                            element.addTag(tag.substring(PLUS.length()));
                        }
                    }
                    if (!copy) continue;
                    mediaPackage.addDerived(element, e);
                }
            }
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }
}

