/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.FileSupport;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Option;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Copy Workflow Operation Handler", "workflow.operation=copy"})
public class CopyWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    public static final String OPT_SOURCE_TAGS = "source-tags";
    public static final String OPT_SOURCE_FLAVORS = "source-flavors";
    public static final String OPT_TARGET_DIRECTORY = "target-directory";
    public static final String OPT_TARGET_FILENAME = "target-filename";
    private static final Logger logger = LoggerFactory.getLogger(CopyWorkflowOperationHandler.class);
    protected Workspace workspace = null;

    @Reference
    protected void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running copy workflow operation on workflow {}", (Object)workflowInstance.getId());
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none);
        List sourceTagsOption = tagsAndFlavors.getSrcTags();
        List sourceFlavorsOption = tagsAndFlavors.getSrcFlavors();
        String targetDirectoryOption = StringUtils.trimToNull((String)currentOperation.getConfiguration(OPT_TARGET_DIRECTORY));
        Option targetFilenameOption = Option.option((Object)StringUtils.trimToNull((String)currentOperation.getConfiguration(OPT_TARGET_FILENAME)));
        StringBuilder sb = new StringBuilder();
        sb.append("Parameters passed to copy workflow operation:");
        sb.append("\n source-tags: ").append(sourceTagsOption);
        sb.append("\n source-flavors: ").append(sourceFlavorsOption);
        sb.append("\n target-directory: ").append(targetDirectoryOption);
        sb.append("\n target-filename: ").append(targetFilenameOption);
        logger.debug(sb.toString());
        SimpleElementSelector elementSelector = new SimpleElementSelector();
        if (sourceTagsOption.isEmpty() && sourceFlavorsOption.isEmpty()) {
            logger.info("No source tags or flavors have been specified, not matching anything");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        if (StringUtils.isBlank((CharSequence)targetDirectoryOption)) {
            throw new WorkflowOperationException("No target directory has been set for the copy operation!");
        }
        for (MediaPackageElementFlavor flavor : sourceFlavorsOption) {
            try {
                elementSelector.addFlavor(flavor);
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException("Source flavor '" + flavor + "' is malformed");
            }
        }
        for (Object tag : sourceTagsOption) {
            elementSelector.addTag((String)tag);
        }
        Collection elements = elementSelector.select(mediaPackage, true);
        if (elements.size() == 0) {
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        if (elements.size() == 1) {
            for (MediaPackageElement element : elements) {
                logger.debug("Copy single element to: {}", (Object)targetDirectoryOption);
                String fileName = targetFilenameOption.isSome() ? (String)targetFilenameOption.get() : FilenameUtils.getBaseName((String)element.getURI().toString());
                String ext = FilenameUtils.getExtension((String)element.getURI().toString());
                ext = ext.length() > 0 ? ".".concat(ext) : "";
                File targetFile = new File(UrlSupport.concat((String)targetDirectoryOption, (String)fileName.concat(ext)));
                this.copyElement(element, targetFile);
            }
        } else {
            logger.debug("Copy multiple elements to: {}", (Object)targetDirectoryOption);
            int i = 1;
            for (MediaPackageElement element : elements) {
                String fileName = targetFilenameOption.isSome() ? String.format((String)targetFilenameOption.get(), i) : FilenameUtils.getBaseName((String)element.getURI().toString());
                String ext = FilenameUtils.getExtension((String)element.getURI().toString());
                ext = ext.length() > 0 ? ".".concat(ext) : "";
                File targetFile = new File(UrlSupport.concat((String)targetDirectoryOption, (String)(fileName + ext)));
                this.copyElement(element, targetFile);
                ++i;
            }
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    private void copyElement(MediaPackageElement element, File targetFile) throws WorkflowOperationException {
        File sourceFile;
        try {
            sourceFile = this.workspace.get(element.getURI());
        }
        catch (NotFoundException e) {
            throw new WorkflowOperationException("Unable to find " + element.getURI() + " in the workspace", (Throwable)e);
        }
        catch (IOException e) {
            throw new WorkflowOperationException("Error loading " + element.getURI() + " from the workspace", (Throwable)e);
        }
        logger.debug("Start copying element {} to target {}.", (Object)sourceFile.getPath(), (Object)targetFile.getPath());
        try {
            FileSupport.copy((File)sourceFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new WorkflowOperationException(String.format("Unable to copy %s to %s: %s", sourceFile.getPath(), targetFile.getPath(), e.getMessage()));
        }
        logger.debug("Element {} copied to target {}.", (Object)sourceFile.getPath(), (Object)targetFile.getPath());
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

