/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.util.XmlNamespaceContext;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Transfer metadata fields between catalogs", "workflow.operation=transfer-metadata"})
public class TransferMetadataWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static Logger logger = LoggerFactory.getLogger(TransferMetadataWorkflowOperationHandler.class);
    private Workspace workspace = null;

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        Metadata targetMetadata;
        Metadata sourceMetadata;
        logger.debug("Running transfer-metadata workflow operation");
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        Configuration configuration = new Configuration(workflowInstance.getCurrentOperation());
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.one, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.one);
        configuration.setSourceFlavor(tagsAndFlavors.getSingleSrcFlavor());
        configuration.setTargetFlavor(tagsAndFlavors.getSingleTargetFlavor());
        try {
            sourceMetadata = new Metadata(mediaPackage, configuration.sourceFlavor);
        }
        catch (Metadata.NoMetadataFoundException e) {
            logger.debug("No catalog with flavor {}. Skipping operation.", (Object)configuration.sourceFlavor);
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        try {
            targetMetadata = new Metadata(mediaPackage, configuration.targetFlavor);
        }
        catch (Metadata.NoMetadataFoundException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        if (targetMetadata.dcCatalog.get(configuration.targetElement).size() > 0 && !configuration.force) {
            throw new WorkflowOperationException("The target metadata field already exists and forcing was not configured");
        }
        if (configuration.concatDelimiter == null) {
            List values = sourceMetadata.dcCatalog.get(configuration.sourceElement);
            targetMetadata.dcCatalog.set(configuration.targetElement, values);
            logger.info("Transferred {} metadata elements", (Object)values.size());
        } else {
            String value = sourceMetadata.dcCatalog.get(configuration.sourceElement).stream().map(DublinCoreValue::getValue).collect(Collectors.joining(configuration.concatDelimiter));
            targetMetadata.dcCatalog.set(configuration.targetElement, value);
            logger.info("Transferred concatenated metadata element(s)");
        }
        if (configuration.targetPrefix != null) {
            XmlNamespaceContext namespace = XmlNamespaceContext.mk((String)configuration.targetPrefix, (String)configuration.targetElement.getNamespaceURI());
            targetMetadata.dcCatalog.addBindings(namespace);
        }
        try {
            targetMetadata.save();
        }
        catch (IOException e) {
            throw new WorkflowOperationException("Error saving updated metadata catalog", (Throwable)e);
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    private class Configuration {
        private MediaPackageElementFlavor sourceFlavor;
        private MediaPackageElementFlavor targetFlavor;
        private final EName sourceElement;
        private final EName targetElement;
        private final boolean force;
        private final String concatDelimiter;
        private final String targetPrefix;

        Configuration(WorkflowOperationInstance operation) throws IllegalArgumentException {
            this.sourceFlavor = MediaPackageElementFlavor.parseFlavor((String)operation.getConfiguration("source-flavor"));
            this.targetFlavor = MediaPackageElementFlavor.parseFlavor((String)operation.getConfiguration("target-flavor"));
            this.sourceElement = EName.fromString((String)operation.getConfiguration("source-element"));
            this.targetElement = EName.fromString((String)operation.getConfiguration("target-element"));
            this.force = BooleanUtils.toBoolean((String)operation.getConfiguration("force"));
            this.concatDelimiter = operation.getConfiguration("concat");
            this.targetPrefix = operation.getConfiguration("target-prefix");
        }

        void setSourceFlavor(MediaPackageElementFlavor flavor) {
            this.sourceFlavor = flavor;
        }

        void setTargetFlavor(MediaPackageElementFlavor flavor) {
            this.targetFlavor = flavor;
        }
    }

    private class Metadata {
        private final MediaPackage mediaPackage;
        private final Catalog catalog;
        private final DublinCoreCatalog dcCatalog;

        Metadata(MediaPackage mediaPackage, MediaPackageElementFlavor flavor) throws NoMetadataFoundException {
            this.mediaPackage = mediaPackage;
            Catalog[] catalogs = mediaPackage.getCatalogs(flavor);
            if (catalogs.length < 1) {
                throw new NoMetadataFoundException();
            }
            if (catalogs.length > 1) {
                logger.warn("More than one metadata catalog of flavor {} found; using the first one", (Object)flavor);
            }
            this.catalog = catalogs[0];
            this.dcCatalog = DublinCoreUtil.loadDublinCore((Workspace)TransferMetadataWorkflowOperationHandler.this.workspace, (MediaPackageElement)this.catalog);
        }

        private void save() throws IOException {
            String filename = FilenameUtils.getName((String)this.catalog.getURI().toString());
            InputStream stream = IOUtils.toInputStream((String)this.dcCatalog.toXmlString(), (Charset)StandardCharsets.UTF_8);
            this.catalog.setURI(TransferMetadataWorkflowOperationHandler.this.workspace.put(this.mediaPackage.getIdentifier().toString(), this.catalog.getIdentifier(), filename, stream));
            this.catalog.setChecksum(null);
        }

        class NoMetadataFoundException
        extends Exception {
            NoMetadataFoundException() {
            }
        }
    }
}

