/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Property;
import org.opencastproject.assetmanager.api.PropertyId;
import org.opencastproject.assetmanager.api.Value;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.ARecord;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.distribution.api.DistributionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.PublicationImpl;
import org.opencastproject.mediapackage.identifier.Id;
import org.opencastproject.mediapackage.identifier.IdImpl;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.metadata.dublincore.OpencastMetadataCodec;
import org.opencastproject.metadata.dublincore.Precision;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AclScope;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.JobUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Duplicate Event Workflow Handler", "workflow.operation=duplicate-event"})
public class DuplicateEventWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(DuplicateEventWorkflowOperationHandler.class);
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    private static final DateFormat ADMIN_UI_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final String SOURCE_FLAVORS_PROPERTY = "source-flavors";
    public static final String SOURCE_TAGS_PROPERTY = "source-tags";
    public static final String TARGET_TAGS_PROPERTY = "target-tags";
    public static final String NUMBER_PROPERTY = "number-of-events";
    public static final String MAX_NUMBER_PROPERTY = "max-number-of-events";
    public static final String NO_SUFFIX = "no-suffix";
    public static final String SET_SERIES_ID = "set-series-id";
    public static final String SET_TITLE = "set-title";
    public static final String SET_START_DATE = "set-start-date-time";
    public static final int MAX_NUMBER_DEFAULT = 25;
    public static final String PROPERTY_NAMESPACES_PROPERTY = "property-namespaces";
    public static final String COPY_NUMBER_PREFIX_PROPERTY = "copy-number-prefix";
    private AssetManager assetManager;
    protected Workspace workspace;
    protected DistributionService distributionService;
    private SeriesService seriesService;
    private AuthorizationService authorizationService;

    @Reference
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Reference
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference(target="(distribution.channel=download)")
    public void setDistributionService(DistributionService distributionService) {
        this.distributionService = distributionService;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.none);
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        List configuredSourceFlavors = tagsAndFlavors.getSrcFlavors();
        List configuredSourceTags = tagsAndFlavors.getSrcTags();
        List configuredTargetTags = tagsAndFlavors.getTargetTags();
        boolean noSuffix = Boolean.parseBoolean(StringUtils.trimToEmpty((String)operation.getConfiguration(NO_SUFFIX)));
        String startDateString = StringUtils.trimToEmpty((String)operation.getConfiguration(SET_START_DATE));
        String seriesId = StringUtils.trimToEmpty((String)operation.getConfiguration(SET_SERIES_ID));
        String title = StringUtils.trimToEmpty((String)operation.getConfiguration(SET_TITLE));
        int numberOfEvents = Integer.parseInt(operation.getConfiguration(NUMBER_PROPERTY));
        String configuredPropertyNamespaces = StringUtils.trimToEmpty((String)operation.getConfiguration(PROPERTY_NAMESPACES_PROPERTY));
        int maxNumberOfEvents = 25;
        if (operation.getConfiguration(MAX_NUMBER_PROPERTY) != null) {
            maxNumberOfEvents = Integer.parseInt(operation.getConfiguration(MAX_NUMBER_PROPERTY));
        }
        if (numberOfEvents > maxNumberOfEvents) {
            throw new WorkflowOperationException("Number of events to create exceeds the maximum of " + maxNumberOfEvents + ". Aborting.");
        }
        SeriesInformation series = null;
        AccessControlList seriesAccessControl = null;
        if (!(seriesId.isEmpty() || seriesId.startsWith("${") || seriesId.endsWith("}"))) {
            try {
                DublinCoreCatalog dc = this.seriesService.getSeries(seriesId);
                series = new SeriesInformation(seriesId, dc, ((DublinCoreValue)dc.get(DublinCore.PROPERTY_TITLE).get(0)).getValue());
                seriesAccessControl = this.seriesService.getSeriesAccessControl(seriesId);
            }
            catch (SeriesException e) {
                throw new WorkflowOperationException((Throwable)e);
            }
            catch (NotFoundException e) {
                throw new WorkflowOperationException("couldn't find series for ID \"" + seriesId + "\"");
            }
            catch (UnauthorizedException e) {
                throw new WorkflowOperationException("not allowed to access series \"" + seriesId + "\"");
            }
        }
        logger.info("Creating {} new media packages from media package with id {}.", (Object)numberOfEvents, (Object)mediaPackage.getIdentifier());
        String[] propertyNamespaces = StringUtils.split((String)configuredPropertyNamespaces, (String)",");
        String copyNumberPrefix = StringUtils.trimToEmpty((String)operation.getConfiguration(COPY_NUMBER_PREFIX_PROPERTY));
        SimpleElementSelector elementSelector = new SimpleElementSelector();
        for (MediaPackageElementFlavor flavor : configuredSourceFlavors) {
            elementSelector.addFlavor(flavor);
        }
        ArrayList<String> removeTags = new ArrayList<String>();
        ArrayList<String> addTags = new ArrayList<String>();
        ArrayList<String> overrideTags = new ArrayList<String>();
        for (String tag : configuredTargetTags) {
            if (tag.startsWith(MINUS)) {
                removeTags.add(tag);
                continue;
            }
            if (tag.startsWith(PLUS)) {
                addTags.add(tag);
                continue;
            }
            overrideTags.add(tag);
        }
        for (String tag : configuredSourceTags) {
            elementSelector.addTag(tag);
        }
        Collection elements = elementSelector.select(mediaPackage, false);
        HashSet<Publication> internalPublications = new HashSet<Publication>();
        ArrayList<String> seriesAclTags = new ArrayList<String>();
        for (MediaPackageElement e : mediaPackage.getElements()) {
            if (e instanceof Publication) {
                if ("internal".equals(((Publication)e).getChannel())) {
                    internalPublications.add((Publication)e);
                }
                elements.remove(e);
            }
            if (MediaPackageElements.EPISODE.equals((Object)e.getFlavor())) {
                elements.remove(e);
            }
            if (series != null && MediaPackageElements.SERIES.equals((Object)e.getFlavor())) {
                elements.remove(e);
            }
            if (series == null || !MediaPackageElements.XACML_POLICY_SERIES.equals((Object)e.getFlavor())) continue;
            seriesAclTags.addAll(Arrays.asList(e.getTags()));
            elements.remove(e);
        }
        MediaPackageElement[] originalEpisodeDc = mediaPackage.getElementsByFlavor(MediaPackageElements.EPISODE);
        if (originalEpisodeDc.length != 1) {
            throw new WorkflowOperationException("Media package " + mediaPackage.getIdentifier() + " has " + originalEpisodeDc.length + " episode dublin cores while it is expected to have exactly 1. Aborting.");
        }
        Object mpIds = "";
        String sep = "";
        HashMap<Object, String> properties = new HashMap<Object, String>();
        for (int i = 0; i < numberOfEvents; ++i) {
            ArrayList<URI> temporaryFiles = new ArrayList<URI>();
            MediaPackage newMp = null;
            try {
                Date mpDate;
                String useTitle;
                String newMpId = workflowInstance.getConfiguration("newMpId");
                if (newMpId == null) {
                    newMpId = UUID.randomUUID().toString();
                }
                if (title.isEmpty() || title.startsWith("${") && title.endsWith("}")) {
                    DublinCoreCatalog dublinCore = (DublinCoreCatalog)DublinCoreUtil.loadEpisodeDublinCore((Workspace)this.workspace, (MediaPackage)mediaPackage).get();
                    useTitle = dublinCore.getFirst(DublinCore.PROPERTY_TITLE);
                } else {
                    useTitle = title;
                }
                if (!noSuffix) {
                    useTitle = String.format("%s (%s %d)", useTitle, copyNumberPrefix, i + 1);
                }
                if (!startDateString.isEmpty() || !startDateString.startsWith("${") && !startDateString.endsWith("}")) {
                    try {
                        mpDate = ADMIN_UI_DATE_FORMAT.parse(startDateString);
                        logger.info("Setting StartDate to {}", (Object)mpDate);
                    }
                    catch (ParseException ex) {
                        logger.warn("Could not parse: {} as date time", (Object)startDateString);
                        mpDate = mediaPackage.getDate();
                        logger.warn("Using original event date {} as default", (Object)mpDate);
                    }
                } else {
                    mpDate = mediaPackage.getDate();
                    logger.warn("No date set, using original event date {} as default", (Object)mpDate);
                }
                newMp = this.copyMediaPackage(mediaPackage, series, newMpId, useTitle, mpDate);
                if (series != null) {
                    URI newSeriesURI = null;
                    String newSeriesId = UUID.randomUUID().toString();
                    try (InputStream seriesDCInputStream = IOUtils.toInputStream((String)series.dc.toXmlString(), (String)"UTF-8");){
                        newSeriesURI = this.workspace.put(newMpId, newSeriesId, "dublincore.xml", seriesDCInputStream);
                    }
                    MediaPackageElementBuilder elementBuilder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
                    MediaPackageElement newSeriesMpElement = elementBuilder.elementFromURI(newSeriesURI, Catalog.TYPE, MediaPackageElements.SERIES);
                    newSeriesMpElement.setIdentifier(newSeriesId);
                    newMp.add(newSeriesMpElement);
                    if (seriesAccessControl != null) {
                        newMp = (MediaPackage)this.authorizationService.setAcl(newMp, AclScope.Series, seriesAccessControl).getA();
                        for (MediaPackageElement seriesAclMpe : newMp.getElementsByFlavor(MediaPackageElements.XACML_POLICY_SERIES)) {
                            for (String tag : seriesAclTags) {
                                seriesAclMpe.addTag(tag);
                            }
                        }
                    }
                }
                newMp = this.copyDublinCore(mediaPackage, originalEpisodeDc[0], newMp, series, removeTags, addTags, overrideTags, temporaryFiles, mpDate);
                for (MediaPackageElement e : elements) {
                    MediaPackageElement element = (MediaPackageElement)e.clone();
                    this.updateTags(element, removeTags, addTags, overrideTags);
                    newMp.add(element);
                }
                for (Publication originalPub : internalPublications) {
                    this.copyPublication(originalPub, mediaPackage, newMp, removeTags, addTags, overrideTags, temporaryFiles);
                }
                this.assetManager.takeSnapshot("default", newMp);
                for (String namespace : propertyNamespaces) {
                    this.copyProperties(namespace, mediaPackage, newMp);
                }
                properties.put("duplicate_media_package_" + (i + 1) + "_id", newMp.getIdentifier().toString());
                mpIds = (String)mpIds + sep + newMp.getIdentifier().toString();
                sep = ", ";
                continue;
            }
            catch (IOException | MediaPackageException e) {
                throw new WorkflowOperationException(e);
            }
            finally {
                this.cleanup(temporaryFiles, Optional.ofNullable(newMp));
            }
        }
        properties.put("duplicate_media_package_ids", (String)mpIds);
        return this.createResult(mediaPackage, properties, WorkflowOperationResult.Action.CONTINUE, 0L);
    }

    private void cleanup(List<URI> temporaryFiles, Optional<MediaPackage> newMp) {
        for (URI temporaryFile : temporaryFiles) {
            try {
                this.workspace.delete(temporaryFile);
            }
            catch (NotFoundException e) {
                logger.debug("{} could not be found in the workspace and hence, cannot be deleted.", (Object)temporaryFile);
            }
            catch (IOException e) {
                logger.warn("Failed to delete {} from workspace.", (Object)temporaryFile);
            }
        }
        newMp.ifPresent(mp -> {
            try {
                this.workspace.cleanup(mp.getIdentifier());
            }
            catch (IOException e) {
                logger.warn("Failed to cleanup the workspace for media package {}", (Object)mp.getIdentifier());
            }
        });
    }

    private void updateTags(MediaPackageElement element, List<String> removeTags, List<String> addTags, List<String> overrideTags) {
        element.setIdentifier(null);
        if (overrideTags.size() > 0) {
            element.clearTags();
            for (String overrideTag : overrideTags) {
                element.addTag(overrideTag);
            }
        } else {
            for (String removeTag : removeTags) {
                element.removeTag(removeTag.substring(MINUS.length()));
            }
            for (String tag : addTags) {
                element.addTag(tag.substring(PLUS.length()));
            }
        }
    }

    private MediaPackage copyMediaPackage(MediaPackage source, SeriesInformation series, String newMpId, String title, Date startDate) throws WorkflowOperationException {
        MediaPackage destination;
        try {
            destination = MediaPackageBuilderFactory.newInstance().newMediaPackageBuilder().createNew((Id)new IdImpl(newMpId));
        }
        catch (MediaPackageException e) {
            logger.error("Failed to create media package " + e.getLocalizedMessage());
            throw new WorkflowOperationException((Throwable)e);
        }
        logger.info("Created mediapackage {}", (Object)destination);
        destination.setDate(source.getDate());
        if (series != null) {
            destination.setSeries(series.id);
            destination.setSeriesTitle(series.title);
        } else {
            destination.setSeries(source.getSeries());
            destination.setSeriesTitle(source.getSeriesTitle());
        }
        destination.setDuration(source.getDuration());
        destination.setLanguage(source.getLanguage());
        destination.setLicense(source.getLicense());
        destination.setDate(startDate);
        destination.setTitle(title);
        return destination;
    }

    private void copyPublication(Publication sourcePublication, MediaPackage source, MediaPackage destination, List<String> removeTags, List<String> addTags, List<String> overrideTags, List<URI> temporaryFiles) throws WorkflowOperationException {
        String newPublicationId = UUID.randomUUID().toString();
        Publication newPublication = PublicationImpl.publication((String)newPublicationId, (String)"internal", null, null);
        HashSet<Object> sourcePubElements = new HashSet<Object>();
        sourcePubElements.addAll(Arrays.asList(sourcePublication.getAttachments()));
        sourcePubElements.addAll(Arrays.asList(sourcePublication.getCatalogs()));
        sourcePubElements.addAll(Arrays.asList(sourcePublication.getTracks()));
        for (MediaPackageElement mediaPackageElement : sourcePubElements) {
            try {
                MediaPackageElement element = (MediaPackageElement)mediaPackageElement.clone();
                try (InputStream inputStream = this.workspace.read(element.getURI());){
                    URI tmpUri = this.workspace.put(destination.getIdentifier().toString(), element.getIdentifier(), FilenameUtils.getName((String)element.getURI().toString()), inputStream);
                    temporaryFiles.add(tmpUri);
                    element.setIdentifier(null);
                    element.setURI(tmpUri);
                }
                destination.add(element);
                Job job = this.distributionService.distribute("internal", destination, element.getIdentifier());
                MediaPackageElement distributedElement = (MediaPackageElement)JobUtil.payloadAsMediaPackageElement((ServiceRegistry)this.serviceRegistry).apply((Object)job);
                destination.remove(element);
                this.updateTags(distributedElement, removeTags, addTags, overrideTags);
                PublicationImpl.addElementToPublication((Publication)newPublication, (MediaPackageElement)distributedElement);
            }
            catch (Exception exception) {
                throw new WorkflowOperationException((Throwable)exception);
            }
        }
        String publicationUri = sourcePublication.getURI().toString();
        publicationUri = publicationUri.replace(source.getIdentifier().toString(), destination.getIdentifier().toString());
        publicationUri = publicationUri.replace(sourcePublication.getIdentifier(), newPublicationId);
        newPublication.setURI(URI.create(publicationUri));
        destination.add((MediaPackageElement)newPublication);
    }

    private MediaPackage copyDublinCore(MediaPackage source, MediaPackageElement sourceDublinCore, MediaPackage destination, SeriesInformation series, List<String> removeTags, List<String> addTags, List<String> overrideTags, List<URI> temporaryFiles, Date creationDate) throws WorkflowOperationException {
        DublinCoreCatalog destinationDublinCore = (DublinCoreCatalog)DublinCoreUtil.loadEpisodeDublinCore((Workspace)this.workspace, (MediaPackage)source).get();
        destinationDublinCore.setIdentifier(null);
        destinationDublinCore.setURI(sourceDublinCore.getURI());
        destinationDublinCore.set(DublinCore.PROPERTY_CREATED, OpencastMetadataCodec.encodeDate((Date)creationDate, (Precision)Precision.Second));
        destinationDublinCore.set(DublinCore.PROPERTY_TITLE, destination.getTitle());
        if (StringUtils.isNotBlank((CharSequence)destinationDublinCore.getFirst(DublinCore.PROPERTY_TEMPORAL))) {
            DublinCoreValue eventTime = EncodingSchemeUtils.encodePeriod((DCMIPeriod)new DCMIPeriod(creationDate, creationDate), (Precision)Precision.Second);
            destinationDublinCore.set(DublinCore.PROPERTY_TEMPORAL, eventTime);
        }
        if (series != null) {
            destinationDublinCore.set(DublinCore.PROPERTY_IS_PART_OF, series.id);
        }
        try (InputStream inputStream = IOUtils.toInputStream((String)destinationDublinCore.toXmlString(), (String)"UTF-8");){
            String elementId = UUID.randomUUID().toString();
            URI newUrl = this.workspace.put(destination.getIdentifier().toString(), elementId, "dublincore.xml", inputStream);
            temporaryFiles.add(newUrl);
            MediaPackageElement mpe = destination.add(newUrl, MediaPackageElement.Type.Catalog, MediaPackageElements.EPISODE);
            for (String tag : sourceDublinCore.getTags()) {
                mpe.addTag(tag);
            }
            this.updateTags(mpe, removeTags, addTags, overrideTags);
            mpe.setIdentifier(elementId);
        }
        catch (IOException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        return destination;
    }

    private void copyProperties(String namespace, MediaPackage source, MediaPackage destination) {
        AQueryBuilder q = this.assetManager.createQuery();
        AResult properties = q.select(new Target[]{q.propertiesOf(new String[]{namespace})}).where(q.mediaPackageId(source.getIdentifier().toString())).run();
        if (properties.getRecords().head().isNone()) {
            logger.info("No properties to copy for media package {}, namespace {}.", (Object)source.getIdentifier(), (Object)namespace);
            return;
        }
        for (Property p : ((ARecord)properties.getRecords().head().get()).getProperties()) {
            PropertyId newPropId = PropertyId.mk((String)destination.getIdentifier().toString(), (String)namespace, (String)p.getId().getName());
            this.assetManager.setProperty(Property.mk((PropertyId)newPropId, (Value)p.getValue()));
        }
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    private static final class SeriesInformation {
        private final String id;
        private final DublinCoreCatalog dc;
        private final String title;

        private SeriesInformation(String id, DublinCoreCatalog dc, String title) {
            this.id = id;
            this.dc = dc;
            this.title = title;
        }
    }
}

