/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.presets.api.PresetProvider;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Defaults Operation Handler", "workflow.operation=defaults"})
public class DefaultsWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultsWorkflowOperationHandler.class);
    private PresetProvider presetProvider;

    @Reference
    void setPresetProvider(PresetProvider presetProvider) {
        this.presetProvider = presetProvider;
    }

    private String getPreset(String organizationId, String seriesID, String key) {
        try {
            if (this.presetProvider != null) {
                return this.presetProvider.getProperty(seriesID, key);
            }
        }
        catch (NotFoundException e) {
            logger.debug("No preset for key {} from organization {} and series {}. Using the default value if available.", new Object[]{key, organizationId, seriesID});
        }
        return null;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Applying default values to {}", (Object)workflowInstance.getId());
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        Long id = workflowInstance.getId();
        String organizationId = workflowInstance.getOrganizationId();
        String seriesID = workflowInstance.getMediaPackage().getSeries();
        HashMap<String, String> properties = new HashMap<String, String>();
        logger.debug("Getting properties for {} {} {}", new Object[]{id, organizationId, seriesID});
        for (String key : operation.getConfigurationKeys()) {
            String value = workflowInstance.getConfiguration(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                String preset = this.getPreset(organizationId, seriesID, key);
                if (StringUtils.isNotBlank((CharSequence)preset)) {
                    properties.put(key, preset);
                    logger.debug("Configuration key '{}' of workflow {} is set to preset value '{}'", new Object[]{key, id, preset});
                    continue;
                }
                String defaultValue = operation.getConfiguration(key);
                properties.put(key, defaultValue);
                logger.debug("Configuration key '{}' of workflow {} is set to default value '{}' specified in workflow", new Object[]{key, id, defaultValue});
                continue;
            }
            properties.put(key, value);
            logger.debug("Configuration key '{}' of workflow {} is set to '{}' specified in event.", new Object[]{key, id, value});
        }
        return this.createResult(workflowInstance.getMediaPackage(), properties, WorkflowOperationResult.Action.CONTINUE, 0L);
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

