/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=move publication elements to workspace", "workflow.operation=publication-channel-to-workspace"})
public class PublicationChannelToWorkspace
extends AbstractWorkflowOperationHandler {
    static final String OPT_SOURCE_PUBLICATION_CHANNEL = "source-channel";
    private static final Logger logger = LoggerFactory.getLogger(PublicationChannelToWorkspace.class);

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.info("Copying artifacts from published media package {} to workspace", (Object)workflowInstance.getId());
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many);
        List configuredSourceFlavors = tagsAndFlavors.getSrcFlavors();
        List configuredSourceTags = tagsAndFlavors.getSrcTags();
        List configuredTargetTags = tagsAndFlavors.getTargetTags();
        String publicationChannel = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(OPT_SOURCE_PUBLICATION_CHANNEL));
        if (publicationChannel.isEmpty()) {
            logger.error("No source publication-channel set.");
            throw new WorkflowOperationException("No source Publication channel set.");
        }
        Optional<Publication> publication = Arrays.stream(mediaPackage.getPublications()).filter(channel -> channel.getChannel().equals(publicationChannel)).findFirst();
        if (publication.get().getTracks().length >= 0) {
            ArrayList tracks = new ArrayList();
            Arrays.stream(publication.get().getTracks()).filter(element -> element.containsTag((Collection)configuredSourceTags)).filter(Objects::nonNull).forEach(element -> tracks.add(element));
            Arrays.stream(publication.get().getTracks()).filter(element -> configuredSourceFlavors.contains(element.getFlavor())).filter(Objects::nonNull).forEach(element -> tracks.add(element));
            if (!configuredTargetTags.isEmpty()) {
                tracks.stream().forEach(track -> configuredTargetTags.stream().forEach(targetTag -> track.addTag(targetTag.toString())));
            }
            tracks.stream().forEach(track -> mediaPackage.add(track));
        }
        if (publication.get().getAttachments().length >= 0) {
            ArrayList attachments = new ArrayList();
            Arrays.stream(publication.get().getAttachments()).filter(element -> element.containsTag((Collection)configuredSourceTags)).filter(Objects::nonNull).forEach(element -> attachments.add(element));
            Arrays.stream(publication.get().getAttachments()).filter(element -> configuredSourceFlavors.contains(element.getFlavor())).filter(Objects::nonNull).forEach(element -> attachments.add(element));
            if (!configuredTargetTags.isEmpty()) {
                attachments.stream().forEach(attachment -> configuredTargetTags.stream().forEach(targetTag -> attachment.addTag(targetTag.toString())));
            }
            attachments.stream().forEach(attachment -> mediaPackage.add(attachment));
        }
        if (publication.get().getCatalogs().length >= 0) {
            ArrayList catalogs = new ArrayList();
            Arrays.stream(publication.get().getCatalogs()).filter(element -> element.containsTag((Collection)configuredSourceTags)).filter(Objects::nonNull).forEach(element -> catalogs.add(element));
            Arrays.stream(publication.get().getCatalogs()).filter(element -> configuredSourceFlavors.contains(element.getFlavor())).filter(Objects::nonNull).forEach(element -> catalogs.add(element));
            if (!configuredTargetTags.isEmpty()) {
                catalogs.stream().forEach(catalog -> configuredTargetTags.stream().forEach(targetTag -> catalog.addTag(targetTag.toString())));
            }
            catalogs.stream().forEach(catalog -> mediaPackage.add(catalog));
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, 0L);
    }
}

