/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.Fraction;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.VideoStream;
import org.opencastproject.mediapackage.track.TrackImpl;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Probe Resolution Operation Handler", "workflow.operation=probe-resolution"})
public class ProbeResolutionWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    static final String OPT_SOURCE_FLAVOR = "source-flavor";
    static final String OPT_VAR_PREFIX = "var:";
    static final String OPT_VAL_PREFIX = "val:";
    private static final Logger logger = LoggerFactory.getLogger(ProbeResolutionWorkflowOperationHandler.class);

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.info("Running probe-resolution workflow operation");
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.one, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none);
        MediaPackageElementFlavor sourceFlavor = tagsAndFlavors.getSingleSrcFlavor();
        Track[] tracks = mediaPackage.getTracks(sourceFlavor);
        if (tracks.length <= 0) {
            logger.info("No tracks with specified flavor ({}).", (Object)sourceFlavor.toString());
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        HashMap resolutionMapping = new HashMap();
        for (Object key : workflowInstance.getCurrentOperation().getConfigurationKeys()) {
            if (!((String)key).startsWith(OPT_VAR_PREFIX)) continue;
            String varName = ((String)key).substring(OPT_VAR_PREFIX.length());
            for (Fraction resolution : this.getResolutions(this.getConfig(workflowInstance, (String)key))) {
                if (!resolutionMapping.containsKey(resolution)) {
                    resolutionMapping.put(resolution, new HashSet());
                }
                ((Set)resolutionMapping.get(resolution)).add(varName);
            }
        }
        HashMap<String, String> valueMapping = new HashMap<String, String>();
        for (String key : workflowInstance.getCurrentOperation().getConfigurationKeys()) {
            if (!key.startsWith(OPT_VAL_PREFIX)) continue;
            String varName = key.substring(OPT_VAL_PREFIX.length());
            valueMapping.put(varName, this.getConfig(workflowInstance, key));
        }
        HashMap<CallSite, String> properties = new HashMap<CallSite, String>();
        for (Track track : tracks) {
            String flavor = ProbeResolutionWorkflowOperationHandler.toVariableName(track.getFlavor());
            if (!track.hasVideo()) continue;
            for (VideoStream video : ((TrackImpl)track).getVideo()) {
                Fraction resolution = Fraction.getFraction((int)video.getFrameWidth(), (int)video.getFrameHeight());
                if (!resolutionMapping.containsKey(resolution)) continue;
                for (String varName : (Set)resolutionMapping.get(resolution)) {
                    String value = valueMapping.containsKey(varName) ? (String)valueMapping.get(varName) : "true";
                    properties.put((CallSite)((Object)(flavor + varName)), value);
                }
            }
        }
        logger.info("Finished workflow operation adding the properties: {}", properties);
        return this.createResult(mediaPackage, properties, WorkflowOperationResult.Action.CONTINUE, 0L);
    }

    List<Fraction> getResolutions(String resolutionsConfig) {
        ArrayList<Fraction> resolutions = new ArrayList<Fraction>();
        for (String res : resolutionsConfig.split(" *, *")) {
            if (!StringUtils.isNotBlank((CharSequence)res)) continue;
            resolutions.add(Fraction.getFraction((String)res.replace('x', '/')));
        }
        return resolutions;
    }

    private static String toVariableName(MediaPackageElementFlavor flavor) {
        return flavor.getType() + "_" + flavor.getSubtype() + "_";
    }
}

