/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.fns.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.handler.workflow.ImportWorkflowPropertiesWOH;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Export Workflow Properties Workflow Operation Handler", "workflow.operation=export-wf-properties"})
public class ExportWorkflowPropertiesWOH
extends AbstractWorkflowOperationHandler {
    public static final String KEYS_PROPERTY = "keys";
    public static final MediaPackageElementFlavor DEFAULT_TARGET_FLAVOR = MediaPackageElements.PROCESSING_PROPERTIES;
    public static final String EXPORTED_PROPERTIES_FILENAME = "processing-properties.xml";
    private static final Logger logger = LoggerFactory.getLogger(ExportWorkflowPropertiesWOH.class);
    private Workspace workspace;

    @Reference
    void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        Attachment attachment;
        logger.info("Start exporting workflow properties for workflow {}", (Object)workflowInstance);
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        Set keys = Stream.$((Iterable)this.getOptConfig(workflowInstance, KEYS_PROPERTY)).bind(Strings.splitCsv).toSet();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many);
        List targetFlavorList = tagsAndFlavors.getTargetFlavors();
        if (targetFlavorList.isEmpty()) {
            targetFlavorList.add(DEFAULT_TARGET_FLAVOR);
        }
        List targetTags = tagsAndFlavors.getTargetTags();
        MediaPackageElementFlavor targetFlavor = (MediaPackageElementFlavor)targetFlavorList.get(0);
        Properties workflowProps = new Properties();
        Opt<Attachment> existingPropsElem = ImportWorkflowPropertiesWOH.loadPropertiesElementFromMediaPackage(targetFlavor, workflowInstance);
        if (existingPropsElem.isSome()) {
            workflowProps = ImportWorkflowPropertiesWOH.loadPropertiesFromXml(this.workspace, ((Attachment)existingPropsElem.get()).getURI());
            for (String key : keys) {
                workflowProps.remove(key);
            }
        }
        for (String key : workflowInstance.getConfigurationKeys()) {
            if (!keys.isEmpty() && !keys.contains(key)) continue;
            workflowProps.put(key, workflowInstance.getConfiguration(key));
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            workflowProps.storeToXML((OutputStream)out, null, "UTF-8");
            String elementId = UUID.randomUUID().toString();
            URI uri = this.workspace.put(mediaPackage.getIdentifier().toString(), elementId, EXPORTED_PROPERTIES_FILENAME, (InputStream)new ByteArrayInputStream(out.toByteArray()));
            MediaPackageElementBuilder builder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
            attachment = (Attachment)builder.elementFromURI(uri, Attachment.TYPE, targetFlavor);
            attachment.setMimeType(MimeTypes.XML);
        }
        catch (IOException e) {
            logger.error("Unable to store workflow properties as Attachment with flavor '{}':", targetFlavorList.get(0), (Object)e);
            throw new WorkflowOperationException("Unable to store workflow properties as Attachment", (Throwable)e);
        }
        for (String tag : targetTags) {
            logger.trace("Tagging with '{}'", (Object)tag);
            attachment.addTag(tag);
        }
        if (existingPropsElem.isSome()) {
            mediaPackage.remove((Attachment)existingPropsElem.get());
        }
        mediaPackage.add(attachment);
        logger.info("Added properties from {} as Attachment with flavor {}", (Object)workflowInstance, targetFlavorList.get(0));
        logger.debug("Workflow properties: {}", (Object)this.propertiesAsString(workflowProps));
        return this.createResult(mediaPackage, null, WorkflowOperationResult.Action.CONTINUE, 0L);
    }

    private String propertiesAsString(Properties properties) {
        StringWriter writer = new StringWriter();
        properties.list(new PrintWriter(writer));
        return writer.getBuffer().toString();
    }
}

