/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.Checksum;
import org.opencastproject.util.ChecksumType;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Clone Workflow Operation Handler", "workflow.operation=clone"})
public class CloneWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    public static final String OPT_SOURCE_FLAVOR = "source-flavor";
    public static final String OPT_SOURCE_TAGS = "source-tags";
    public static final String OPT_TARGET_FLAVOR = "target-flavor";
    private static final Logger logger = LoggerFactory.getLogger(CloneWorkflowOperationHandler.class);
    protected Workspace workspace = null;

    @Reference
    protected void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running clone workflow operation on workflow {}", (Object)workflowInstance.getId());
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.one);
        List sourceTagsOption = tagsAndFlavors.getSrcTags();
        List sourceFlavorOptionList = tagsAndFlavors.getSrcFlavors();
        String targetFlavorOption = StringUtils.trimToNull((String)currentOperation.getConfiguration(OPT_TARGET_FLAVOR));
        SimpleElementSelector elementSelector = new SimpleElementSelector();
        if (sourceTagsOption.isEmpty() && sourceFlavorOptionList.isEmpty()) {
            logger.info("No source tags or flavors have been specified, not matching anything. Operation will be skipped.");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        MediaPackageElementFlavor sourceFlavorOption = sourceFlavorOptionList.isEmpty() ? new MediaPackageElementFlavor("*", "*") : (MediaPackageElementFlavor)sourceFlavorOptionList.get(0);
        StringBuilder sb = new StringBuilder();
        sb.append("Parameters passed to clone workflow operation:");
        sb.append("\n source-tags: ").append(sourceTagsOption);
        sb.append("\n source-flavor: ").append(sourceFlavorOption);
        sb.append("\n target-flavor: ").append(targetFlavorOption);
        logger.debug(sb.toString());
        MediaPackageElementFlavor sourceFlavor = sourceFlavorOption;
        elementSelector.addFlavor(sourceFlavor);
        for (String tag : sourceTagsOption) {
            elementSelector.addTag(tag);
        }
        Collection elements = elementSelector.select(mediaPackage, true);
        if (elements.size() == 0) {
            logger.debug("No matching elements found, skipping operation.");
            return this.createResult(workflowInstance.getMediaPackage(), WorkflowOperationResult.Action.SKIP);
        }
        logger.debug("Copy " + elements.size() + " elements to new flavor: {}", (Object)targetFlavorOption);
        MediaPackageElementFlavor targetFlavor = MediaPackageElementFlavor.parseFlavor((String)targetFlavorOption);
        for (MediaPackageElement element : elements) {
            MediaPackageElementFlavor flavor = targetFlavor.applyTo(element.getFlavor());
            MediaPackageElement newElement = this.copyElement(element);
            newElement.setFlavor(flavor);
            mediaPackage.add(newElement);
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    private MediaPackageElement copyElement(MediaPackageElement element) throws WorkflowOperationException {
        String elementId = UUID.randomUUID().toString();
        MediaPackageElement newElement = (MediaPackageElement)element.clone();
        newElement.setIdentifier(elementId);
        File sourceFile = null;
        Object toFileName = null;
        try {
            URI sourceURI = element.getURI();
            sourceFile = this.workspace.get(sourceURI);
            toFileName = elementId;
            String extension = FilenameUtils.getExtension((String)sourceFile.getName());
            if (!"".equals(extension)) {
                toFileName = (String)toFileName + "." + extension;
            }
            logger.debug("Start copying element {} to target {}.", (Object)sourceFile.getPath(), toFileName);
            URI newUri = this.workspace.put(element.getMediaPackage().getIdentifier().toString(), newElement.getIdentifier(), (String)toFileName, this.workspace.read(sourceURI));
            newElement.setURI(newUri);
            newElement.setChecksum(Checksum.create((ChecksumType)ChecksumType.DEFAULT_TYPE, (File)this.workspace.get(newUri)));
            logger.debug("Element {} copied to target {}.", (Object)sourceFile.getPath(), toFileName);
        }
        catch (IOException e) {
            throw new WorkflowOperationException("Unable to copy " + sourceFile.getPath() + " to " + toFileName + ".", (Throwable)e);
        }
        catch (NotFoundException e) {
            throw new WorkflowOperationException("Unable to find " + element.getURI() + " in the workspace", (Throwable)e);
        }
        return newElement;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

