/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.util.HashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.conditionparser.WorkflowConditionInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalConfigWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    public static final String CONFIGURATION_NAME = "configuration-name";
    public static final String CONDITION_PREFIX = "condition-";
    public static final String VALUE_PREFIX = "value-";
    public static final String NO_MATCH = "no-match";
    private static final Logger logger = LoggerFactory.getLogger(ConditionalConfigWorkflowOperationHandler.class);

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        HashMap<String, String> properties = new HashMap<String, String>();
        String wfConfigName = operation.getConfiguration(CONFIGURATION_NAME);
        if (StringUtils.isEmpty((CharSequence)wfConfigName)) {
            logger.warn("No workflow configuration was set because {} was not passed. Operation skipped.", (Object)CONFIGURATION_NAME);
            return this.createResult(WorkflowOperationResult.Action.SKIP);
        }
        String value = "false";
        for (String key : operation.getConfigurationKeys().stream().filter(x -> x.startsWith(CONDITION_PREFIX)).sorted().collect(Collectors.toList())) {
            String condition = operation.getConfiguration(key);
            if (StringUtils.isEmpty((CharSequence)condition)) continue;
            boolean result = false;
            try {
                result = WorkflowConditionInterpreter.interpret((String)condition.trim());
                logger.debug("Evaluate condition: {}, result: {}", (Object)condition, (Object)result);
            }
            catch (IllegalArgumentException e) {
                logger.error("Invalid condition to evaluate: {}.", (Object)condition);
                throw new WorkflowOperationException(String.format("Invalid condition: %s", condition.trim()), (Throwable)e);
            }
            if (!result) continue;
            String valuePropName = VALUE_PREFIX + key.substring(CONDITION_PREFIX.length());
            value = operation.getConfiguration(valuePropName);
            if (StringUtils.isEmpty((CharSequence)value)) {
                logger.error("Condition {}  evaluated to true, but no value informed to set {} variable in {}", new Object[]{condition.trim(), wfConfigName, valuePropName});
                throw new WorkflowOperationException(String.format("Condition: %s does not have a value set.", condition.trim()));
            }
            properties.put(wfConfigName, value.trim());
            logger.debug("Configuration key '{}' of workflow {} is set to value '{}'", new Object[]{wfConfigName, this.id, value.trim()});
            return this.createResult(workflowInstance.getMediaPackage(), properties, WorkflowOperationResult.Action.CONTINUE, 0L);
        }
        String noMatch = operation.getConfiguration(NO_MATCH);
        if (StringUtils.isNotEmpty((CharSequence)NO_MATCH)) {
            properties.put(wfConfigName, noMatch);
            logger.debug("Configuration key '{}' of workflow {} is set to value '{}'", new Object[]{wfConfigName, this.id, noMatch});
            return this.createResult(workflowInstance.getMediaPackage(), properties, WorkflowOperationResult.Action.CONTINUE, 0L);
        }
        return this.createResult(WorkflowOperationResult.Action.SKIP);
    }
}

