/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import com.entwinemedia.fn.data.Opt;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.api.WorkflowService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartWorkflowWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(StartWorkflowWorkflowOperationHandler.class);
    public static final String MEDIA_PACKAGE_ID = "media-package";
    public static final String WORKFLOW_DEFINITION = "workflow-definition";
    private AssetManager assetManager;
    private WorkflowService workflowService;

    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        String configuredMediaPackageID = StringUtils.trimToEmpty((String)operation.getConfiguration(MEDIA_PACKAGE_ID));
        String configuredWorkflowDefinition = StringUtils.trimToEmpty((String)operation.getConfiguration(WORKFLOW_DEFINITION));
        Opt mpOpt = this.assetManager.getMediaPackage(configuredMediaPackageID);
        if (mpOpt.isNone()) {
            throw new WorkflowOperationException(String.format("Media package %s not found", configuredMediaPackageID));
        }
        MediaPackage mp = (MediaPackage)mpOpt.get();
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String key : operation.getConfigurationKeys()) {
            if (MEDIA_PACKAGE_ID.equals(key) || WORKFLOW_DEFINITION.equals(key)) continue;
            properties.put(key, operation.getConfiguration(key));
        }
        try {
            WorkflowDefinition workflowDefinition = this.workflowService.getWorkflowDefinitionById(configuredWorkflowDefinition);
            logger.info("Starting '{}' workflow for media package '{}'", (Object)configuredWorkflowDefinition, (Object)configuredMediaPackageID);
            this.workflowService.start(workflowDefinition, mp, properties);
        }
        catch (NotFoundException e) {
            throw new WorkflowOperationException(String.format("Workflow Definition '%s' not found", configuredWorkflowDefinition));
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        return this.createResult(WorkflowOperationResult.Action.CONTINUE);
    }
}

