/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(TagWorkflowOperationHandler.class);
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    public static final String SOURCE_FLAVORS_PROPERTY = "source-flavors";
    public static final String SOURCE_TAGS_PROPERTY = "source-tags";
    public static final String TARGET_FLAVOR_PROPERTY = "target-flavor";
    public static final String TARGET_TAGS_PROPERTY = "target-tags";
    public static final String COPY_PROPERTY = "copy";

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many);
        List configuredSourceFlavors = tagsAndFlavors.getSrcFlavors();
        List configuredSourceTags = tagsAndFlavors.getSrcTags();
        List configuredTargetFlavor = tagsAndFlavors.getTargetFlavors();
        List configuredTargetTags = tagsAndFlavors.getTargetTags();
        boolean copy = BooleanUtils.toBoolean((String)currentOperation.getConfiguration(COPY_PROPERTY));
        if (copy) {
            logger.info("Retagging mediapackage elements as a copy");
        } else {
            logger.info("Retagging mediapackage elements");
        }
        SimpleElementSelector elementSelector = new SimpleElementSelector();
        for (MediaPackageElementFlavor flavor : configuredSourceFlavors) {
            elementSelector.addFlavor(flavor);
        }
        ArrayList<String> removeTags = new ArrayList<String>();
        ArrayList<String> addTags = new ArrayList<String>();
        ArrayList<String> overrideTags = new ArrayList<String>();
        for (String tag : configuredTargetTags) {
            if (tag.startsWith(MINUS)) {
                removeTags.add(tag);
                continue;
            }
            if (tag.startsWith(PLUS)) {
                addTags.add(tag);
                continue;
            }
            overrideTags.add(tag);
        }
        for (String tag : configuredSourceTags) {
            elementSelector.addTag(tag);
        }
        Collection elements = elementSelector.select(mediaPackage, false);
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            MediaPackageElement e;
            MediaPackageElement element = e = (MediaPackageElement)iterator.next();
            if (copy) {
                element = (MediaPackageElement)e.clone();
                element.setIdentifier(null);
                element.setURI(e.getURI());
            }
            if (!configuredTargetFlavor.isEmpty()) {
                MediaPackageElementFlavor targetFlavor = (MediaPackageElementFlavor)configuredTargetFlavor.get(0);
                String targetFlavorType = targetFlavor.getType();
                String targetFlavorSubtype = targetFlavor.getSubtype();
                if ("*".equals(targetFlavorType)) {
                    targetFlavorType = element.getFlavor().getType();
                }
                if ("*".equals(targetFlavorSubtype)) {
                    targetFlavorSubtype = element.getFlavor().getSubtype();
                }
                String targetFlavorStr = targetFlavorType + "/" + targetFlavorSubtype;
                element.setFlavor(MediaPackageElementFlavor.parseFlavor((String)targetFlavorStr));
            }
            if (overrideTags.size() > 0) {
                element.clearTags();
                for (String tag : overrideTags) {
                    element.addTag(tag);
                }
            } else {
                for (String tag : removeTags) {
                    element.removeTag(tag.substring(MINUS.length()));
                }
                for (String tag : addTags) {
                    element.addTag(tag.substring(PLUS.length()));
                }
            }
            if (!copy) continue;
            mediaPackage.addDerived(element, e);
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }
}

