/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.DefaultMediaPackageSerializerImpl;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.util.Checksum;
import org.opencastproject.util.ChecksumType;
import org.opencastproject.util.FileSupport;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.ZipUtil;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ZipWorkflowOperationHandler.class);
    public static final String ZIP_COLLECTION_PROPERTY = "zip-collection";
    public static final String INCLUDE_FLAVORS_PROPERTY = "include-flavors";
    public static final String TARGET_FLAVOR_PROPERTY = "target-flavor";
    public static final String TARGET_TAGS_PROPERTY = "target-tags";
    public static final String COMPRESS_PROPERTY = "compression";
    public static final String DEFAULT_ZIP_COLLECTION = "zip";
    public static final String DEFAULT_ZIP_ARCHIVE_TEMP_DIR = "tmp/zip";
    public static final String ZIP_ARCHIVE_TEMP_DIR_CFG_KEY = "org.opencastproject.workflow.handler.workflow.ZipWorkflowOperationHandler.tmpdir";
    public static final MediaPackageElementFlavor DEFAULT_ARCHIVE_FLAVOR = MediaPackageElementFlavor.parseFlavor((String)"archive/zip");
    protected File tempStorageDir = null;
    protected Workspace workspace;

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    protected void activate(ComponentContext cc) {
        this.tempStorageDir = StringUtils.isNotBlank((CharSequence)cc.getBundleContext().getProperty(ZIP_ARCHIVE_TEMP_DIR_CFG_KEY)) ? new File(cc.getBundleContext().getProperty(ZIP_ARCHIVE_TEMP_DIR_CFG_KEY)) : new File(cc.getBundleContext().getProperty("org.opencastproject.storage.dir"), DEFAULT_ZIP_ARCHIVE_TEMP_DIR);
        try {
            FileUtils.forceMkdir((File)this.tempStorageDir);
        }
        catch (IOException e) {
            logger.error("Could not create temporary directory for ZIP archives: `{}`", (Object)this.tempStorageDir.getAbsolutePath());
            throw new IllegalStateException(e);
        }
        try {
            FileUtils.cleanDirectory((File)this.tempStorageDir);
        }
        catch (IOException e) {
            logger.error("Could not clean temporary directory for ZIP archives: `{}`", (Object)this.tempStorageDir.getAbsolutePath());
            throw new IllegalStateException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        if (workflowInstance == null) {
            throw new WorkflowOperationException("Invalid workflow instance");
        }
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        if (currentOperation == null) {
            throw new WorkflowOperationException("Cannot get current workflow operation");
        }
        String flavors = currentOperation.getConfiguration(INCLUDE_FLAVORS_PROPERTY);
        ArrayList<MediaPackageElementFlavor> flavorsToZip = new ArrayList<MediaPackageElementFlavor>();
        MediaPackageElementFlavor targetFlavor = DEFAULT_ARCHIVE_FLAVOR;
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many);
        List targetFlavorOption = tagsAndFlavors.getTargetFlavors();
        try {
            targetFlavor = targetFlavorOption.isEmpty() ? DEFAULT_ARCHIVE_FLAVOR : (MediaPackageElementFlavor)targetFlavorOption.get(0);
            logger.trace("Using '{}' as the target flavor for the zip archive of recording {}", (Object)targetFlavor, (Object)mediaPackage);
        }
        catch (IllegalArgumentException e) {
            throw new WorkflowOperationException("Flavor '" + targetFlavorOption + "' is not valid", (Throwable)e);
        }
        List targetTags = tagsAndFlavors.getTargetTags();
        if (flavors == null) {
            flavorsToZip.add(MediaPackageElementFlavor.parseFlavor((String)"*/*"));
        } else {
            for (String flavor : this.asList(flavors)) {
                flavorsToZip.add(MediaPackageElementFlavor.parseFlavor((String)flavor));
            }
        }
        logger.info("Archiving mediapackage {} in workflow {}", (Object)mediaPackage, (Object)workflowInstance);
        String compressProperty = currentOperation.getConfiguration(COMPRESS_PROPERTY);
        boolean compress = compressProperty == null ? false : Boolean.valueOf(compressProperty);
        File zip = null;
        try {
            logger.info("Creating zipped archive of recording {}", (Object)mediaPackage);
            zip = this.zip(mediaPackage, flavorsToZip, compress);
        }
        catch (Exception e) {
            throw new WorkflowOperationException("Unable to create a zip archive from mediapackage " + mediaPackage, (Throwable)e);
        }
        String configuredCollectionId = currentOperation.getConfiguration(ZIP_COLLECTION_PROPERTY);
        String collectionId = configuredCollectionId == null ? DEFAULT_ZIP_COLLECTION : configuredCollectionId;
        logger.info("Moving zipped archive of recording {} to the working file repository collection '{}'", (Object)mediaPackage, (Object)collectionId);
        FileInputStream in = null;
        URI uri = null;
        in = new FileInputStream(zip);
        uri = this.workspace.putInCollection(collectionId, mediaPackage.getIdentifier().toString() + ".zip", (InputStream)in);
        logger.info("Zipped archive of recording {} is available from {}", (Object)mediaPackage, (Object)uri);
        IOUtils.closeQuietly((InputStream)in);
        Attachment attachment = (Attachment)MediaPackageElementBuilderFactory.newInstance().newElementBuilder().elementFromURI(uri, MediaPackageElement.Type.Attachment, targetFlavor);
        try {
            attachment.setChecksum(Checksum.create((ChecksumType)ChecksumType.DEFAULT_TYPE, (File)zip));
        }
        catch (IOException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            try {
                throw new WorkflowOperationException("zip file " + zip + " not found", (Throwable)e);
                catch (IOException e2) {
                    throw new WorkflowOperationException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        attachment.setMimeType(MimeTypes.ZIP);
        for (String tag : targetTags) {
            attachment.addTag(tag);
            logger.trace("Tagging the archive of recording '{}' with '{}'", (Object)mediaPackage, (Object)tag);
        }
        attachment.setMimeType(MimeTypes.ZIP);
        try {
            FileUtils.forceDelete((File)zip);
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        mediaPackage.add(attachment);
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    protected File zip(MediaPackage mediaPackage, List<MediaPackageElementFlavor> flavorsToZip, boolean compress) throws IOException, NotFoundException, MediaPackageException, WorkflowOperationException {
        if (mediaPackage == null) {
            throw new WorkflowOperationException("Invalid mediapackage");
        }
        File mediaPackageDir = new File(this.tempStorageDir, mediaPackage.getIdentifier().toString());
        FileUtils.forceMkdir((File)mediaPackageDir);
        DefaultMediaPackageSerializerImpl serializer = new DefaultMediaPackageSerializerImpl(mediaPackageDir);
        MediaPackage clone = (MediaPackage)mediaPackage.clone();
        for (MediaPackageElement element : clone.getElements()) {
            boolean remove = true;
            for (MediaPackageElementFlavor flavor : flavorsToZip) {
                if (!flavor.matches(element.getFlavor())) continue;
                remove = false;
                break;
            }
            if (remove) {
                clone.remove(element);
                continue;
            }
            File elementDir = new File(mediaPackageDir, element.getIdentifier());
            FileUtils.forceMkdir((File)elementDir);
            File workspaceFile = this.workspace.get(element.getURI());
            File linkedFile = FileSupport.link((File)workspaceFile, (File)new File(elementDir, workspaceFile.getName()), (boolean)true);
            try {
                element.setURI(serializer.encodeURI(linkedFile.toURI()));
            }
            catch (URISyntaxException e) {
                throw new MediaPackageException("unable to serialize a mediapackage element", (Throwable)e);
            }
        }
        FileUtils.writeStringToFile((File)new File(mediaPackageDir, "manifest.xml"), (String)MediaPackageParser.getAsXml((MediaPackage)clone), (String)"UTF-8");
        File zip = new File(this.tempStorageDir, clone.getIdentifier().toString() + ".zip");
        int compressValue = compress ? -1 : 0;
        long startTime = System.currentTimeMillis();
        ZipUtil.zip((File[])new File[]{mediaPackageDir}, (File)zip, (boolean)true, (int)compressValue);
        long stopTime = System.currentTimeMillis();
        logger.debug("Zip file creation took {} seconds", (Object)((stopTime - startTime) / 1000L));
        FileUtils.forceDelete((File)mediaPackageDir);
        return zip;
    }
}

